/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends PlainDiagram {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6mOE03mSRygAqa-2sUB1zgHs3y67oAViE8BbUK9nOX6dku3u0zmxFUutqbz4LtRlcsP4hTScvGoY-Y3e0Uzk2-r3wNzz4EOiUH7ScH9SG0g8ukWI-P5kP3jzKcL82RxyZVJFg8c_kaepeSDd0_UtWMiJ21dDARPxcJAlLqYb59-_yX7w138rLbrJbICmjvO2rb-oUYLzo_zDdQtBGo7CqjqAZC2eQ8JBFFOO_vygg70ATWurxFHZEfLKBOTgLMApxKqHhQIvOrQeR_9Hg-QY62r5YdyqKl2BP8R6dCm-ILxqcyOVTHCwN9yAoN9FG6TRFJgVz7QkAx7y8j67W2VuWcm6Hi1of2wY-RdfHiF30mxrkwZ6bfRSyoG9Wane8H_-KPYINf9dLy1Dmwi68FpUXWAI7DIeXhELkm6LbDYYqy9L5_k5kMKTbgTod3GyXLXucQW5L0aI7tH1PzGyRqtkxWPRfAT4OzegbCy2EsYR2_h6bXB1V6qVcYNuAqQvbDGupdlltxKNWDtIygg7CKSuPw0kMoZ4U6k1-X7eiJbXYRwct5d8WgYFqvi-TAuvgLM4Kt9BMQpJbx3bjPmVkgJ91YLv2YpwU-ANOWjui4bNKwe1NsYLf5dd2vYqpD-N7Yt_VI-ufaJith1e8rmXwQ_V4PiP2W4wE8NPq4q136MLLXt51YBOBNHiW7O4qWdbo779H_oIFl8J06yk8Rh2HaWJ-FFBaeSEBc8WKzUcS06m-PIYBXe-3x1GeIdeLbG9fRVny9qvMlOvRMnQ9ktcURl16FandQLOcAzGuH669Nf6SyxRsaVO9NWM7wTvrNkMSnNWKk4zQkFQBpBWvmmP4IawNV5UpsoPXmd3BFQSbodTyyZWuA5R3jpDeZdCA9E7B1i6XnDHhO-4_hOO_fOXcvtN6bIVOEjqdH7SpCY2rrkJMwevek6noI9EDWb8CnUlE2KB5n2iPTd971Kb8j-nUX8ov7UgJy9IfIuqZTXOxYeyetiKvE6y9rOzvayVw5n0bMeJXAG5Crj2-SpyW0oiLVJCjYHs__U51MFhsnCJX-BB9jf-SWF159WUmddW81B9G5gYbpKn0lZkZxlLqsiTvl6tBwSO1qaBIGHKGQOptb1cwgazmiPwY_wVj6MB2t_-jKURd9hisdi8edKG5u08Bz1HBWWXdW9V7pPC1vnWYOiECbovPkbP8B9W2trm4tLvcz6uunVBZSj5QyyFLVBTt0uNyy4tfBW85ULzJIcPjfb1DT8ltdMuoK7nTr5bM2INlJcPZ8HDe8fpT-pMDjHZoG0pc0EL2UpT_LbPQ6ZC_Ggaod02vFijaaf6XHPMQreH2u4rSk7stfQJyepwJ4RqaxNE6Nlrq3Z8rVKN8GhV3WbvGPYuNIHE1EZDDISMTFDD0FcYMYY9fHqTTkvWXVmF_WZUI3Xc6nzOv0cbUPODENIJx8EpG7qWxo4ia8d5Ibr5B9HoF90YAPYpMiQpIDjf2yxe7K2dA1Z_tziGBYVH_8fcbrxLIEPopBsuWiY6-xj8R56oDI0T-rhcigqpSZld8Xrswd_WEyvtFg9kNKH00b5BWjUMWtHtOvzQ6ZQrvteLnt6PfuF9BsHNjFELWQtnOWkodCr0YIS1X1q85P9NuLVx1wuvvyYlzwbI6AZXUUOMTEEvDp0MAvR4KzA0waqMvTht1-xanGc54ui5BYmLRlGmgLihd6h7JPlrf569NALYl8Snkxcav9yg1fNIDRcze6P9Q5rtbj4Pd6nXBi_xl7jX1fNw9UfJmHu33TU7RvmXlRAiOXyX50RLk31POW00";

    public PSystemDonors(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create(UmlSource source) {
        return new PSystemDonors(source);
    }
}

