/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.braille.BrailleDrawer;
import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.braille.DriverCenteredCharacterBraille;
import net.sourceforge.plantuml.braille.DriverDotPathBraille;
import net.sourceforge.plantuml.braille.DriverLineBraille;
import net.sourceforge.plantuml.braille.DriverNoneBraille;
import net.sourceforge.plantuml.braille.DriverPolygonBraille;
import net.sourceforge.plantuml.braille.DriverRectangleBraille;
import net.sourceforge.plantuml.braille.DriverTextBraille;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class UGraphicBraille
extends AbstractUGraphic<BrailleGrid>
implements ClipContainer {
    public static final int QUANTA = 4;
    private final BrailleGrid grid;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicBraille(this);
    }

    public UGraphicBraille(HColor defaultBackground, ColorMapper colorMapper) {
        this(defaultBackground, colorMapper, new BrailleGrid(4.0));
    }

    private UGraphicBraille(UGraphicBraille other) {
        super(other);
        this.grid = other.grid;
        this.register();
    }

    private UGraphicBraille(HColor defaultBackground, ColorMapper colorMapper, BrailleGrid grid) {
        super(defaultBackground, colorMapper, FileFormat.BRAILLE_PNG.getDefaultStringBounder(), grid);
        this.grid = grid;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverNoneBraille());
        this.registerDriver(URectangle.class, new DriverRectangleBraille(this));
        this.registerDriver(UText.class, new DriverTextBraille());
        this.registerDriver(ULine.class, new DriverLineBraille(this));
        this.registerDriver(UPolygon.class, new DriverPolygonBraille(this));
        this.registerDriver(UEllipse.class, new DriverNoneBraille());
        this.registerDriver(UImage.class, new DriverNoneBraille());
        this.registerDriver(UPath.class, new DriverNoneBraille());
        this.registerDriver(DotPath.class, new DriverDotPathBraille());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterBraille());
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ImageBuilder.plainPngBuilder(new BrailleDrawer((BrailleGrid)this.getGraphicObject())).metadata(metadata).write(os);
    }
}

