YARP 3.3.0 (2019-12-05)                                                {#v3_3_0}
=======================

[TOC]

YARP 3.3.0 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.3.0%22).


Important Changes
-----------------

### Dependencies

* CMake 3.12 or later is now required.
* Optional dependency on YCM now requires version 0.11.0 or later.
* C++14 is now required.
* OpenCV 4 is now explicitly unsupported.
* Visual Studio 2015 is no longer supported.

### Build System

* CMake config files are now installed in lib/cmake also on windows.
* The `OS` component is deprecated in favour of `os` (lowercase).


### Libraries

#### YARP_os

* The `YARP_OS` was renamed `YARP_os`. Using the old name is still supported,
  but deprecated.
* `yAssert` is now a proper assertion macro (removed when `NDEBUG` is defined,
  i.e. `Release builds). If the expression tested has side-effects, program
  behavior will be different depending on whether NDEBUG is defined. This may
  create Heisenbugs which go away when debugging is turned on.
* All `yarp::os::Mutex` related classes and methods are now deprecated in favour
  of `std::mutex`:
  * Classes:
    * `yarp::os::Mutex`
    * `yarp::os::RecursiveMutex`
    * `yarp::os::AbstractLockGuard`
    * `yarp::os::LockGuard`
    * `yarp::os::RecursiveLockGuard`
  * Methods:
    * `yarp::os::Contactable::setCallbackLock(yarp::os::Mutex*)`
    * `yarp::os::AbstractContactable::setCallbackLock(yarp::os::Mutex*)`
    * `yarp::os::Port::setCallbackLock(yarp::os::Mutex*)`
    * `yarp::os::Buffered::setCallbackLock(yarp::os::Mutex*)`
    * `yarp::os::Timer::Timer(..., yarp::os::Mutex*)`
* `yarp::os::Network::getDirectorySeparator` and
  `yarp::os::Network::getPathSeparator` are now deprecated in favour of
  `yarp::conf::filesystem::preferred_separator` and
  `yarp::conf::filesystem::path_separator`respectively.
* `yarp::os::Runnable` is now deprecated.
* `yarp::os::RateThreadWrapper` is now deprecated.
* The `yarp::os::Property` constructor using 'hash_size' was deprecated (it was
  already unused since the internal structure was ported to use std::map).
* `yarp::os::MessageStack` constructor now accepts the max number of thread as
  `size_t` instead of `int`.
* `yarp::os::MessageStack` constructor is now explicit.
* `yarp::os::MessageStack` copy and move constructors and operators are now
  explicitly deleted.


#### YARP_dev

* All devices are now plugins. They are enabled by default, but can be disabled
  if required.
* The `<yarp/dev/GenericSensorInterfaces.h>` include file is deprecated in
  favour of `<yarp/dev/IGenericSensor.h>`.
* The `<yarp/dev/PreciselyTimed.h>` include file is deprecated in favour of
  `<yarp/dev/IPreciselyTimed.h>`.
* The `<yarp/dev/SerialInterfaces.h>` include file is deprecated in favour of
  `<yarp/dev/ISerialDevice.h>`.
* The `<yarp/dev/Wrapper.h>` include file is deprecated in favour of
  `<yarp/dev/IWrapper.h>` and `<yarp/dev/IMultipleWrapper.h>`.
* `yarp::dev::DataSource` and `yarp::dev::DataSource2` are now deprecated.
* `yarp::dev::DataWriter` and `yarp::dev::DataWriter2` are now deprecated

New Features
------------


### Build System

* The `yarp_idl_to_dir` command now accepts the `PLACEMENT` option:
   * `MERGED`:        headers and sources in `<OUTPUT_DIR>/<namespace>`
   * `SEPARATE`:      headers in `<OUTPUT_DIR>/include/<namespace>` sources in `<OUTPUT_DIR>/src/<namespace>`
   * `SEPARATE_EVEN`: alias for `SEPARATE`
   * `SEPARATE_ODD`:  headers in `<OUTPUT_DIR>/include/<namespace>` sources in `<OUTPUT_DIR>/src`
  For backwards compatibility the default value is `SEPARATE_ODD`.
* After calling the `yarp_add_idl` method, the `YARP_ADD_IDL_INCLUDE_DIR`
  variable contains the include directory for using the header files

### Libraries

#### YARP_conf

* Added `yarp::conf::filesystem` utilities (robotology/yarp#1855).

#### YARP_os

* Cleanup of the signature of the following methods of `yarp::os::Network`:
  * `static bool connect(const std::string& src, const std::string& dest, const ContactStyle& style)`
  * `static bool connect(const std::string& src, const std::string& dest, const std::string& carrier = "",  bool quiet = true)`
  * `static bool connect(const char* src, const char* dest, const char* carrier,  bool quiet = true)`
  * `static bool disconnect(const std::string& src, const std::string& dest, bool quiet)`
  * `static bool disconnect(const std::string& src, const std::string& dest, const ContactStyle& style)`
  * `static bool disconnect(const std::string& src, const std::string& dest, const std::string& carrier = "", bool quiet = true)`
  * `static bool disconnect(const char* src, const char* dest, const char* carrier, bool quiet = true)`
  * `static bool isConnected(const std::string& src, const std::string& dest, bool quiet)`
  * `static bool isConnected(const std::string& src, const std::string& dest, const ContactStyle& style)`
  * `static bool isConnected(const std::string& src, const std::string& dest, const std::string& carrier = "", bool quiet = true)`
  * `static bool isConnected(const char* src, const char* dest, const char* carrier,  bool quiet = true)`
* Added move constructor and assignment operator to `yarp::os::Searchable`.
* Added move constructor and assignment operator to `yarp::os::Bottle`.
* Added move constructor and assignment operator to `yarp::os::Property`.
* Added constructors that accept `std::mutex` instead of `yarp::os::Mutex` to
  `yarp::os::Timer`.
* The Log colors can now be enabled also on windows when supported
  (robotology/yarp#2076)
* Added `setCallbackLock` overrides to `yarp::os::Contactable`,
  `yarp::os::AbstractContactable`, `yarp::os::Port`, `yarp::os::BufferedPort`
  to pass a `std::mutex` instead of a `yarp::os::Mutex`.


#### YARP_dev

* Added new interface `yarp::dev::IFrameTranformClientControl`
* `yarp::dev::TransformClient` implements the new interface
  `yarp::dev::IFrameTranformClientControl`.
* The rpc port of the `yarp::dev::TransformClient` allows to reconnect to the
  server.
* `yarp::dev::TransformServer` allows the use of wildcard to erase all the
  transforms between a specified source and `*` or  between `*` and a specified
  destination.
* The rpc port of the `yarp::dev::TransformServer` allows to delete a given
  transform.

#### YARP_run

* The `ENABLE_YARPRUN_LOG` fixed and deprecated in favour of
  `YARP_ENABLE_YARPRUN_LOG`.


### Tools

##### `yarpidl_trift`

* yarpidl_thrift now places the source files according to the "separate" layout.

##### `yarpdatadumper`

* Fixed creating directories whose name contains not allowed characters (e.g.
  `:`, `*`, ...).
* It's now possible to dump PNG images.
* The timestamp info are now provided within `info.log`.

### GUIs

##### `yarpdataplayer`

* `info.log` files containing timestamp info are now handled.


### devices

#### multipleanalogsensorsclient

* Added the option `externalConnection`(false by default). This option disables
  the automatic connect to the `rpc:o` and `measures:o` of the respective
  `multipleanalogsensorsserver`. This implies that with this configuration the
  metadata is missing, then the device lacks of some informations such as the
  sensor name, the frame name etc. On the other hand it allows to
  connect/disconnect the client to the port `measures:o` of the server after
  being opened, and to work also when the `rpc:o` port is missing (e.g with the
  `yarpdataplayer`).

##### `realsense2`

* Deprecated the `needAlignment` parameter in favour of `alignmentFrame`.
  The default behaviour has been maintaned, if not specified `alignmentFrame`
  is `RGB`. The allowed values are `RGB`, `Depth` and `None`.

##### `mjpeg`

* The `MJPEG_AUTOCOMPRESS` CMake option is deprecated in favour of
  `YARP_MJPEG_AUTOCOMPRESS`

##### `mpi`

* The `MPI_DEBUG_MSG` CMake option is deprecated in favour of
  `YARP_MPI_DEBUG_MSG`.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.2.0..v3.3.0`):
```
   332	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    26	Nicolò Genesio <nicolo.genesio@iit.it>
     7	Ugo Pattacini <ugo.pattacini@iit.it>
     5	Vadim Tikhanoff <vadim.tikhanoff@iit.it>
     4	Marco Randazzo <marco.randazzo@iit.it>
     2	Bartek Łukawski <bwmn.peter@gmail.com>
     1	Carlotta Sartore <carlotta.sartore@iit.it>
     1	Giovanni Saponaro <gsaponaro@isr.tecnico.ulisboa.pt>
     1	Giulio Romualdi <giulio.romualdi@gmail.com>
     1	Nicola Piga <nicolapiga@gmail.com>
     1	Silvio Traversaro <silvio.traversaro@iit.it>
     1	Valentina Gaggero <valentina.gaggero@iit.it>
```
