"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuppressionIgnoreErrors = exports.SuppressionIgnoreNever = exports.SuppressionIgnoreAlways = exports.SuppressionIgnoreOr = exports.SuppressionIgnoreAnd = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const nag_pack_1 = require("./nag-pack");
/**
 * Ignore the suppression if all of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreAnd {
    constructor(...SuppressionIgnoreAnds) {
        if (SuppressionIgnoreAnds.length === 0) {
            throw new Error('SuppressionIgnoreAnd needs at least one INagSuppressionIgnore');
        }
        this.andSuppressionIgnores = SuppressionIgnoreAnds;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.andSuppressionIgnores) {
            const m = i.createMessage(input);
            messages.push(m);
            if (!m) {
                return '';
            }
        }
        return messages.join('\n\t');
    }
}
exports.SuppressionIgnoreAnd = SuppressionIgnoreAnd;
_a = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAnd[_a] = { fqn: "cdk-nag.SuppressionIgnoreAnd", version: "2.23.4" };
/**
 * Ignore the suppression if any of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreOr {
    constructor(...orSuppressionIgnores) {
        if (orSuppressionIgnores.length === 0) {
            throw new Error('SuppressionIgnoreOr needs at least one INagSuppressionIgnore');
        }
        this.SuppressionIgnoreOrs = orSuppressionIgnores;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.SuppressionIgnoreOrs) {
            const m = i.createMessage(input);
            if (m) {
                messages.push(m);
            }
        }
        return messages ? messages.join('\n\t') : '';
    }
}
exports.SuppressionIgnoreOr = SuppressionIgnoreOr;
_b = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreOr[_b] = { fqn: "cdk-nag.SuppressionIgnoreOr", version: "2.23.4" };
/**
 * Always ignore the suppression
 */
class SuppressionIgnoreAlways {
    constructor(triggerMessage) {
        if (triggerMessage.length === 0) {
            throw new Error('provide a triggerMessage for the SuppressionIgnoreAlways');
        }
        this.triggerMessage = triggerMessage;
    }
    createMessage(_input) {
        return this.triggerMessage;
    }
}
exports.SuppressionIgnoreAlways = SuppressionIgnoreAlways;
_c = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAlways[_c] = { fqn: "cdk-nag.SuppressionIgnoreAlways", version: "2.23.4" };
/**
 * Don't ignore the suppression
 */
class SuppressionIgnoreNever {
    createMessage(_input) {
        return '';
    }
}
exports.SuppressionIgnoreNever = SuppressionIgnoreNever;
_d = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreNever[_d] = { fqn: "cdk-nag.SuppressionIgnoreNever", version: "2.23.4" };
/**
 * Ignore Suppressions for Rules with a NagMessageLevel.ERROR
 */
class SuppressionIgnoreErrors {
    createMessage(input) {
        return input.ruleLevel == nag_pack_1.NagMessageLevel.ERROR
            ? `${input.ruleId} is categorized as an ERROR and may not be suppressed`
            : '';
    }
}
exports.SuppressionIgnoreErrors = SuppressionIgnoreErrors;
_e = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreErrors[_e] = { fqn: "cdk-nag.SuppressionIgnoreErrors", version: "2.23.4" };
//# sourceMappingURL=data:application/json;base64,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