"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.unionValidator=exports.requireProperty=exports.requiredValidator=exports.propertyValidator=exports.hashValidator=exports.listValidator=exports.validateCfnTag=exports.validateObject=exports.validateDate=exports.validateBoolean=exports.validateNumber=exports.validateString=exports.canInspect=exports.VALIDATION_SUCCESS=exports.ValidationResults=exports.ValidationResult=exports.unionMapper=exports.hashMapper=exports.listMapper=exports.cfnTagToCloudFormation=exports.dateToCloudFormation=exports.numberToCloudFormation=exports.objectToCloudFormation=exports.booleanToCloudFormation=exports.stringToCloudFormation=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");function identity(x){return x}exports.stringToCloudFormation=identity,exports.booleanToCloudFormation=identity,exports.objectToCloudFormation=identity,exports.numberToCloudFormation=identity;function dateToCloudFormation(x){if(x)return`${x.getUTCFullYear()}-${pad(x.getUTCMonth()+1)}-${pad(x.getUTCDate())}T${pad(x.getUTCHours())}:${pad(x.getUTCMinutes())}:${pad(x.getUTCSeconds())}`}exports.dateToCloudFormation=dateToCloudFormation;function pad(x){return x<10?"0"+x.toString():x.toString()}function cfnTagToCloudFormation(x){return{Key:x.key,Value:x.value}}exports.cfnTagToCloudFormation=cfnTagToCloudFormation;function listMapper(elementMapper){return x=>canInspect(x)?x.map(elementMapper):x}exports.listMapper=listMapper;function hashMapper(elementMapper){return x=>{if(!canInspect(x))return x;const ret={};return Object.keys(x).forEach(key=>{ret[key]=elementMapper(x[key])}),ret}}exports.hashMapper=hashMapper;function unionMapper(validators,mappers){if(validators.length!==mappers.length)throw Error("Not the same amount of validators and mappers passed to unionMapper()");return x=>{if(!canInspect(x))return x;for(let i=0;i<validators.length;i++)if(validators[i](x).isSuccess)return mappers[i](x);throw new TypeError("No validators matched in the union()")}}exports.unionMapper=unionMapper;class ValidationResult{constructor(errorMessage="",results=new ValidationResults){this.errorMessage=errorMessage,this.results=results;try{jsiiDeprecationWarnings.aws_cdk_lib_ValidationResults(results)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ValidationResult),error}}get isSuccess(){return!this.errorMessage&&this.results.isSuccess}assertSuccess(){if(!this.isSuccess){let message=this.errorTree();throw message=message.slice(0,1).toUpperCase()+message.slice(1),new CfnSynthesisError(message)}}errorTree(){const childMessages=this.results.errorTreeList();return this.errorMessage+(childMessages.length?`
  ${childMessages.replace(/\n/g,`
  `)}`:"")}prefix(message){return this.isSuccess?this:new ValidationResult(`${message}: ${this.errorMessage}`,this.results)}}exports.ValidationResult=ValidationResult,_a=JSII_RTTI_SYMBOL_1,ValidationResult[_a]={fqn:"aws-cdk-lib.ValidationResult",version:"2.69.0"};class ValidationResults{constructor(results=[]){this.results=results}collect(result){try{jsiiDeprecationWarnings.aws_cdk_lib_ValidationResult(result)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.collect),error}result.isSuccess||this.results.push(result)}get isSuccess(){return this.results.every(x=>x.isSuccess)}errorTreeList(){return this.results.map(child=>child.errorTree()).join(`
`)}wrap(message){return this.isSuccess?exports.VALIDATION_SUCCESS:new ValidationResult(message,this)}}exports.ValidationResults=ValidationResults,_b=JSII_RTTI_SYMBOL_1,ValidationResults[_b]={fqn:"aws-cdk-lib.ValidationResults",version:"2.69.0"},exports.VALIDATION_SUCCESS=new ValidationResult;function canInspect(x){return x!=null&&!isCloudFormationIntrinsic(x)&&!isCloudFormationDynamicReference(x)}exports.canInspect=canInspect;function validateString(x){return canInspect(x)&&typeof x!="string"?new ValidationResult(`${JSON.stringify(x)} should be a string`):exports.VALIDATION_SUCCESS}exports.validateString=validateString;function validateNumber(x){return canInspect(x)&&typeof x!="number"?new ValidationResult(`${JSON.stringify(x)} should be a number`):exports.VALIDATION_SUCCESS}exports.validateNumber=validateNumber;function validateBoolean(x){return canInspect(x)&&typeof x!="boolean"?new ValidationResult(`${JSON.stringify(x)} should be a boolean`):exports.VALIDATION_SUCCESS}exports.validateBoolean=validateBoolean;function validateDate(x){return canInspect(x)&&!(x instanceof Date)?new ValidationResult(`${JSON.stringify(x)} should be a Date`):x!==void 0&&isNaN(x.getTime())?new ValidationResult("got an unparseable Date"):exports.VALIDATION_SUCCESS}exports.validateDate=validateDate;function validateObject(x){return canInspect(x)&&typeof x!="object"?new ValidationResult(`${JSON.stringify(x)} should be an 'object'`):exports.VALIDATION_SUCCESS}exports.validateObject=validateObject;function validateCfnTag(x){return canInspect(x)&&(x.key==null||x.value==null)?new ValidationResult(`${JSON.stringify(x)} should have a 'key' and a 'value' property`):exports.VALIDATION_SUCCESS}exports.validateCfnTag=validateCfnTag;function listValidator(elementValidator){return x=>{if(!canInspect(x))return exports.VALIDATION_SUCCESS;if(!x.forEach)return new ValidationResult(`${JSON.stringify(x)} should be a list`);for(let i=0;i<x.length;i++){const element=x[i],result=elementValidator(element);if(!result.isSuccess)return result.prefix(`element ${i}`)}return exports.VALIDATION_SUCCESS}}exports.listValidator=listValidator;function hashValidator(elementValidator){return x=>{if(!canInspect(x))return exports.VALIDATION_SUCCESS;for(const key of Object.keys(x)){const result=elementValidator(x[key]);if(!result.isSuccess)return result.prefix(`element '${key}'`)}return exports.VALIDATION_SUCCESS}}exports.hashValidator=hashValidator;function propertyValidator(propName,validator){return x=>validator(x).prefix(propName)}exports.propertyValidator=propertyValidator;function requiredValidator(x){return x==null?new ValidationResult("required but missing"):exports.VALIDATION_SUCCESS}exports.requiredValidator=requiredValidator;function requireProperty(props,name,context){const value=props[name];if(value==null)throw new Error(`${context.toString()} is missing required property: ${name}`);return value}exports.requireProperty=requireProperty;function unionValidator(...validators){return x=>{const results=new ValidationResults;let eitherOr="either";for(const validator of validators){const result=validator(x);if(result.isSuccess)return result;results.collect(result.prefix(eitherOr)),eitherOr="or"}return results.wrap("not one of the possible types")}}exports.unionValidator=unionValidator;function isCloudFormationIntrinsic(x){if(typeof x!="object")return!1;const keys=Object.keys(x);return keys.length!==1?!1:keys[0]==="Ref"||keys[0].slice(0,4)==="Fn::"}function isCloudFormationDynamicReference(x){return typeof x=="string"&&x.startsWith("{{resolve:")&&x.endsWith("}}")}class CfnSynthesisError extends Error{constructor(){super(...arguments),this.type="CfnSynthesisError"}}
