"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.addCustomSynthesis=exports.synthesize=void 0;const cxapi=require("../../../cx-api"),metadata_resource_1=require("./metadata-resource"),prepare_app_1=require("./prepare-app"),tree_metadata_1=require("./tree-metadata"),annotations_1=require("../annotations"),app_1=require("../app"),aspect_1=require("../aspect"),stack_1=require("../stack"),stage_1=require("../stage");function synthesize(root,options={}){injectTreeMetadata(root),synthNestedAssemblies(root,options),invokeAspects(root),injectMetadataResources(root),prepare_app_1.prepareApp(root),options.skipValidation||validateTree(root);const builder=stage_1.Stage.isStage(root)?root._assemblyBuilder:new cxapi.CloudAssemblyBuilder(options.outdir);return synthesizeTree(root,builder,options.validateOnSynthesis),builder.buildAssembly()}exports.synthesize=synthesize;const CUSTOM_SYNTHESIS_SYM=Symbol.for("@aws-cdk/core:customSynthesis");function addCustomSynthesis(construct,synthesis){Object.defineProperty(construct,CUSTOM_SYNTHESIS_SYM,{value:synthesis,enumerable:!1})}exports.addCustomSynthesis=addCustomSynthesis;function getCustomSynthesis(construct){return construct[CUSTOM_SYNTHESIS_SYM]}function synthNestedAssemblies(root,options){for(const child of root.node.children)stage_1.Stage.isStage(child)?child.synth(options):synthNestedAssemblies(child,options)}function invokeAspects(root){const invokedByPath={};let nestedAspectWarning=!1;recurse(root,[]);function recurse(construct,inheritedAspects){const node=construct.node,aspects=aspect_1.Aspects.of(construct),allAspectsHere=[...inheritedAspects??[],...aspects.all],nodeAspectsCount=aspects.all.length;for(const aspect of allAspectsHere){let invoked=invokedByPath[node.path];invoked||(invoked=invokedByPath[node.path]=[]),!invoked.includes(aspect)&&(aspect.visit(construct),!nestedAspectWarning&&nodeAspectsCount!==aspects.all.length&&(annotations_1.Annotations.of(construct).addWarning("We detected an Aspect was added via another Aspect, and will not be applied"),nestedAspectWarning=!0),invoked.push(aspect))}for(const child of construct.node.children)stage_1.Stage.isStage(child)||recurse(child,allAspectsHere)}}function injectMetadataResources(root){visit(root,"post",construct=>{if(!stack_1.Stack.isStack(construct)||!construct._versionReportingEnabled)return;const CDKMetadata="CDKMetadata";construct.node.tryFindChild(CDKMetadata)||new metadata_resource_1.MetadataResource(construct,CDKMetadata)})}function injectTreeMetadata(root){visit(root,"post",construct=>{if(!app_1.App.isApp(construct)||!construct._treeMetadata)return;const CDKTreeMetadata="Tree";construct.node.tryFindChild(CDKTreeMetadata)||new tree_metadata_1.TreeMetadata(construct)})}function synthesizeTree(root,builder,validateOnSynth=!1){visit(root,"post",construct=>{const session={outdir:builder.outdir,assembly:builder,validateOnSynth};stack_1.Stack.isStack(construct)?construct.synthesizer.synthesize(session):construct instanceof tree_metadata_1.TreeMetadata?construct._synthesizeTree(session):getCustomSynthesis(construct)?.onSynthesize(session)})}function validateTree(root){const errors=new Array;if(visit(root,"pre",construct=>{for(const message of construct.node.validate())errors.push({message,source:construct})}),errors.length>0){const errorList=errors.map(e=>`[${e.source.node.path}] ${e.message}`).join(`
  `);throw new Error(`Validation failed with the following errors:
  ${errorList}`)}}function visit(root,order,cb){order==="pre"&&cb(root);for(const child of root.node.children)stage_1.Stage.isStage(child)||visit(child,order,cb);order==="post"&&cb(root)}
