"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ExportWriter=void 0;const path=require("path"),constructs_1=require("constructs"),export_reader_provider_1=require("./export-reader-provider"),types_1=require("./types"),cfn_dynamic_reference_1=require("../../cfn-dynamic-reference"),custom_resource_1=require("../../custom-resource"),lazy_1=require("../../lazy"),uniqueid_1=require("../../private/uniqueid"),stack_1=require("../../stack"),custom_resource_provider_1=require("../custom-resource-provider");class ExportWriter extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),this._references={};const stack=stack_1.Stack.of(this),region=props.region??stack.region,resourceType="Custom::CrossRegionExportWriter",serviceToken=custom_resource_provider_1.CustomResourceProvider.getOrCreate(this,resourceType,{codeDirectory:path.join(__dirname,"cross-region-ssm-writer-handler"),runtime:custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_14_X,policyStatements:[{Effect:"Allow",Resource:stack.formatArn({service:"ssm",resource:"parameter",region,resourceName:`${types_1.SSM_EXPORT_PATH_PREFIX}*`}),Action:["ssm:DeleteParameters","ssm:ListTagsForResource","ssm:GetParameters","ssm:PutParameter"]}]}),properties={region,exports:lazy_1.Lazy.any({produce:()=>this._references})};new custom_resource_1.CustomResource(this,"Resource",{resourceType,serviceToken,properties:{WriterProps:properties}})}static getOrCreate(scope,uniqueId,props){const stack=stack_1.Stack.of(scope),existing=stack.node.tryFindChild(uniqueId);return existing||new ExportWriter(stack,uniqueId,{region:props.region})}exportValue(exportName,reference,importStack){const stack=stack_1.Stack.of(this),parameterName=`/${types_1.SSM_EXPORT_PATH_PREFIX}${exportName}`,ref=new cfn_dynamic_reference_1.CfnDynamicReference(cfn_dynamic_reference_1.CfnDynamicReferenceService.SSM,parameterName);return this._references[parameterName]=stack.resolve(reference.toString()),this.addToExportReader(parameterName,ref,importStack)}addToExportReader(exportName,exportValueRef,importStack){const readerConstructName=uniqueid_1.makeUniqueId(["ExportsReader"]);return export_reader_provider_1.ExportReader.getOrCreate(importStack.nestedStackParent??importStack,readerConstructName).importValue(exportName,exportValueRef)}}exports.ExportWriter=ExportWriter;
