"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.NotificationsResourceHandler=exports.NotificationsResourceHandlerProps=void 0;const fs=require("fs"),path=require("path"),iam=require("../../../aws-iam"),cdk=require("../../../core"),constructs_1=require("constructs");class NotificationsResourceHandlerProps{}exports.NotificationsResourceHandlerProps=NotificationsResourceHandlerProps;class NotificationsResourceHandler extends constructs_1.Construct{constructor(scope,id,props={}){super(scope,id),this.role=props.role??new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("lambda.amazonaws.com")}),this.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole")),this.role.addToPrincipalPolicy(new iam.PolicyStatement({actions:["s3:PutBucketNotification"],resources:["*"]}));const resourceType="AWS::Lambda::Function";class InLineLambda extends cdk.CfnResource{constructor(){super(...arguments),this.tags=new cdk.TagManager(cdk.TagType.STANDARD,resourceType)}renderProperties(properties){return properties.Tags=cdk.listMapper(cdk.cfnTagToCloudFormation)(this.tags.renderTags()),delete properties.tags,properties}}const handlerSourceWithoutComments=fs.readFileSync(path.join(__dirname,"lambda/index.py"),"utf8").replace(/^ *#.*\n?/gm,"");if(handlerSourceWithoutComments.length>4096)throw new Error(`Source of Notifications Resource Handler is too large (${handlerSourceWithoutComments.length} > 4096)`);const resource=new InLineLambda(this,"Resource",{type:resourceType,properties:{Description:'AWS CloudFormation handler for "Custom::S3BucketNotifications" resources (@aws-cdk/aws-s3)',Code:{ZipFile:handlerSourceWithoutComments},Handler:"index.handler",Role:this.role.roleArn,Runtime:"python3.9",Timeout:300}});resource.node.addDependency(this.role),this.functionArn=resource.getAtt("Arn").toString()}static singleton(context,props={}){const root=cdk.Stack.of(context),logicalId="BucketNotificationsHandler050a0587b7544547bf325f094a3db834";let lambda=root.node.tryFindChild(logicalId);return lambda||(lambda=new NotificationsResourceHandler(root,logicalId,props)),lambda}addToRolePolicy(statement){this.role.addToPrincipalPolicy(statement)}}exports.NotificationsResourceHandler=NotificationsResourceHandler;
