"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DockerImageAsset=exports.Platform=exports.NetworkMode=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),assets_1=require("../../assets"),ecr=require("../../aws-ecr"),core_1=require("../../core"),cxapi=require("../../cx-api"),constructs_1=require("constructs");class NetworkMode{constructor(mode){this.mode=mode}static fromContainer(containerId){return new NetworkMode(`container:${containerId}`)}static custom(mode){return new NetworkMode(mode)}}exports.NetworkMode=NetworkMode,_a=JSII_RTTI_SYMBOL_1,NetworkMode[_a]={fqn:"aws-cdk-lib.aws_ecr_assets.NetworkMode",version:"2.69.0"},NetworkMode.DEFAULT=new NetworkMode("default"),NetworkMode.HOST=new NetworkMode("host"),NetworkMode.NONE=new NetworkMode("none");class Platform{constructor(platform){this.platform=platform}static custom(platform){return new Platform(platform)}}exports.Platform=Platform,_b=JSII_RTTI_SYMBOL_1,Platform[_b]={fqn:"aws-cdk-lib.aws_ecr_assets.Platform",version:"2.69.0"},Platform.LINUX_AMD64=new Platform("linux/amd64"),Platform.LINUX_ARM64=new Platform("linux/arm64");class DockerImageAsset extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_assets_DockerImageAssetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DockerImageAsset),error}validateProps(props);const dir=path.resolve(props.directory);if(!fs.existsSync(dir))throw new Error(`Cannot find image directory at ${dir}`);this.dockerfilePath=props.file||"Dockerfile";const file=path.join(dir,this.dockerfilePath);if(!fs.existsSync(file))throw new Error(`Cannot find file at ${file}`);const defaultIgnoreMode=core_1.FeatureFlags.of(this).isEnabled(cxapi.DOCKER_IGNORE_SUPPORT)?core_1.IgnoreMode.DOCKER:core_1.IgnoreMode.GLOB;let ignoreMode=props.ignoreMode??defaultIgnoreMode,exclude=props.exclude||[];const ignore=path.join(dir,".dockerignore");fs.existsSync(ignore)&&(exclude=[...fs.readFileSync(ignore).toString().split(`
`).filter(e=>!!e),...exclude,"!.dockerignore"]),exclude.push("!"+path.basename(file));const cdkout=core_1.Stage.of(this)?.outdir??"cdk.out";exclude.push(cdkout),props.repositoryName&&core_1.Annotations.of(this).addWarning('DockerImageAsset.repositoryName is deprecated. Override "core.Stack.addDockerImageAsset" to control asset locations');const extraHash={};props.invalidation?.extraHash!==!1&&props.extraHash&&(extraHash.user=props.extraHash),props.invalidation?.buildArgs!==!1&&props.buildArgs&&(extraHash.buildArgs=props.buildArgs),props.invalidation?.buildSecrets!==!1&&props.buildSecrets&&(extraHash.buildSecrets=props.buildSecrets),props.invalidation?.target!==!1&&props.target&&(extraHash.target=props.target),props.invalidation?.file!==!1&&props.file&&(extraHash.file=props.file),props.invalidation?.repositoryName!==!1&&props.repositoryName&&(extraHash.repositoryName=props.repositoryName),props.invalidation?.networkMode!==!1&&props.networkMode&&(extraHash.networkMode=props.networkMode),props.invalidation?.platform!==!1&&props.platform&&(extraHash.platform=props.platform),props.invalidation?.outputs!==!1&&props.outputs&&(extraHash.outputs=props.outputs),extraHash.version="1.21.0";const staging=new core_1.AssetStaging(this,"Staging",{...props,follow:props.followSymlinks??toSymlinkFollow(props.follow),exclude,ignoreMode,sourcePath:dir,extraHash:Object.keys(extraHash).length===0?void 0:JSON.stringify(extraHash)});this.sourceHash=staging.assetHash,this.assetHash=staging.assetHash;const stack=core_1.Stack.of(this);this.assetPath=staging.relativeStagedPath(stack),this.dockerBuildArgs=props.buildArgs,this.dockerBuildSecrets=props.buildSecrets,this.dockerBuildTarget=props.target,this.dockerOutputs=props.outputs,this.dockerCacheFrom=props.cacheFrom,this.dockerCacheTo=props.cacheTo;const location=stack.synthesizer.addDockerImageAsset({directoryName:this.assetPath,dockerBuildArgs:this.dockerBuildArgs,dockerBuildSecrets:this.dockerBuildSecrets,dockerBuildTarget:this.dockerBuildTarget,dockerFile:props.file,sourceHash:staging.assetHash,networkMode:props.networkMode?.mode,platform:props.platform?.platform,dockerOutputs:this.dockerOutputs,dockerCacheFrom:this.dockerCacheFrom,dockerCacheTo:this.dockerCacheTo});this.repository=ecr.Repository.fromRepositoryName(this,"Repository",location.repositoryName),this.imageUri=location.imageUri,this.imageTag=location.imageTag??this.assetHash}addResourceMetadata(resource,resourceProperty){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(resource)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addResourceMetadata),error}this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)&&(resource.cfnOptions.metadata=resource.cfnOptions.metadata||{},resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PATH_KEY]=this.assetPath,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY]=this.dockerfilePath,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY]=this.dockerBuildArgs,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY]=this.dockerBuildSecrets,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY]=this.dockerBuildTarget,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY]=resourceProperty,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY]=this.dockerOutputs,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY]=this.dockerCacheFrom,resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY]=this.dockerCacheTo)}}exports.DockerImageAsset=DockerImageAsset,_c=JSII_RTTI_SYMBOL_1,DockerImageAsset[_c]={fqn:"aws-cdk-lib.aws_ecr_assets.DockerImageAsset",version:"2.69.0"};function validateProps(props){for(const[key,value]of Object.entries(props))if(core_1.Token.isUnresolved(value))throw new Error(`Cannot use Token as value of '${key}': this value is used before deployment starts`);validateBuildArgs(props.buildArgs),validateBuildSecrets(props.buildSecrets)}function validateBuildProps(buildPropName,buildProps){for(const[key,value]of Object.entries(buildProps||{}))if(core_1.Token.isUnresolved(key)||core_1.Token.isUnresolved(value))throw new Error(`Cannot use tokens in keys or values of "${buildPropName}" since they are needed before deployment`)}function validateBuildArgs(buildArgs){validateBuildProps("buildArgs",buildArgs)}function validateBuildSecrets(buildSecrets){validateBuildProps("buildSecrets",buildSecrets)}function toSymlinkFollow(follow){switch(follow){case void 0:return;case assets_1.FollowMode.NEVER:return core_1.SymlinkFollowMode.NEVER;case assets_1.FollowMode.ALWAYS:return core_1.SymlinkFollowMode.ALWAYS;case assets_1.FollowMode.BLOCK_EXTERNAL:return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;case assets_1.FollowMode.EXTERNAL:return core_1.SymlinkFollowMode.EXTERNAL}}
