"use strict";var _a,_b,_c,_d,_e;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AssembleWith=exports.SplitType=exports.BatchStrategy=exports.AcceleratorType=exports.AcceleratorClass=exports.Mode=exports.ContainerDefinition=exports.CompressionType=exports.InputMode=exports.RecordWrapperType=exports.S3DataDistributionType=exports.S3DataType=exports.DockerImage=exports.S3Location=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_ecr_assets_1=require("../../../aws-ecr-assets"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions");class S3Location{static fromBucket(bucket,keyPrefix){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBucket),error}return new StandardS3Location({bucket,keyPrefix,uri:bucket.urlForObject(keyPrefix)})}static fromJsonExpression(expression){return new StandardS3Location({uri:sfn.JsonPath.stringAt(expression)})}}exports.S3Location=S3Location,_a=JSII_RTTI_SYMBOL_1,S3Location[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.S3Location",version:"2.69.0"};class DockerImage{static fromEcrRepository(repository,tagOrDigest="latest"){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_IRepository(repository)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrRepository),error}return new StandardDockerImage({repository,imageUri:repository.repositoryUriForTagOrDigest(tagOrDigest)})}static fromJsonExpression(expression,allowAnyEcrImagePull=!0){return new StandardDockerImage({imageUri:expression,allowAnyEcrImagePull})}static fromRegistry(imageUri){return new StandardDockerImage({imageUri})}static fromAsset(scope,id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_assets_DockerImageAssetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}const asset=new aws_ecr_assets_1.DockerImageAsset(scope,id,props);return new StandardDockerImage({repository:asset.repository,imageUri:asset.imageUri})}}exports.DockerImage=DockerImage,_b=JSII_RTTI_SYMBOL_1,DockerImage[_b]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.DockerImage",version:"2.69.0"};var S3DataType;(function(S3DataType2){S3DataType2.MANIFEST_FILE="ManifestFile",S3DataType2.S3_PREFIX="S3Prefix",S3DataType2.AUGMENTED_MANIFEST_FILE="AugmentedManifestFile"})(S3DataType=exports.S3DataType||(exports.S3DataType={}));var S3DataDistributionType;(function(S3DataDistributionType2){S3DataDistributionType2.FULLY_REPLICATED="FullyReplicated",S3DataDistributionType2.SHARDED_BY_S3_KEY="ShardedByS3Key"})(S3DataDistributionType=exports.S3DataDistributionType||(exports.S3DataDistributionType={}));var RecordWrapperType;(function(RecordWrapperType2){RecordWrapperType2.NONE="None",RecordWrapperType2.RECORD_IO="RecordIO"})(RecordWrapperType=exports.RecordWrapperType||(exports.RecordWrapperType={}));var InputMode;(function(InputMode2){InputMode2.PIPE="Pipe",InputMode2.FILE="File"})(InputMode=exports.InputMode||(exports.InputMode={}));var CompressionType;(function(CompressionType2){CompressionType2.NONE="None",CompressionType2.GZIP="Gzip"})(CompressionType=exports.CompressionType||(exports.CompressionType={}));class ContainerDefinition{constructor(options){this.options=options;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_ContainerDefinitionOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ContainerDefinition),error}}bind(task){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_ISageMakerTask(task)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}return{parameters:{ContainerHostname:this.options.containerHostName,Image:this.options.image?.bind(task).imageUri,Mode:this.options.mode,ModelDataUrl:this.options.modelS3Location?.bind(task,{forReading:!0}).uri,ModelPackageName:this.options.modelPackageName,Environment:this.options.environmentVariables?.value}}}}exports.ContainerDefinition=ContainerDefinition,_c=JSII_RTTI_SYMBOL_1,ContainerDefinition[_c]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.ContainerDefinition",version:"2.69.0"};var Mode;(function(Mode2){Mode2.SINGLE_MODEL="SingleModel",Mode2.MULTI_MODEL="MultiModel"})(Mode=exports.Mode||(exports.Mode={}));class AcceleratorClass{constructor(version){this.version=version}static of(version){return new AcceleratorClass(version)}}exports.AcceleratorClass=AcceleratorClass,_d=JSII_RTTI_SYMBOL_1,AcceleratorClass[_d]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.AcceleratorClass",version:"2.69.0"},AcceleratorClass.EIA1=AcceleratorClass.of("eia1"),AcceleratorClass.EIA2=AcceleratorClass.of("eia2");class AcceleratorType{constructor(instanceTypeIdentifier){this.instanceTypeIdentifier=instanceTypeIdentifier}static of(acceleratorClass,instanceSize){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_AcceleratorClass(acceleratorClass),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InstanceSize(instanceSize)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.of),error}return new AcceleratorType(`ml.${acceleratorClass}.${instanceSize}`)}toString(){return this.instanceTypeIdentifier}}exports.AcceleratorType=AcceleratorType,_e=JSII_RTTI_SYMBOL_1,AcceleratorType[_e]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.AcceleratorType",version:"2.69.0"};var BatchStrategy;(function(BatchStrategy2){BatchStrategy2.MULTI_RECORD="MultiRecord",BatchStrategy2.SINGLE_RECORD="SingleRecord"})(BatchStrategy=exports.BatchStrategy||(exports.BatchStrategy={}));var SplitType;(function(SplitType2){SplitType2.NONE="None",SplitType2.LINE="Line",SplitType2.RECORD_IO="RecordIO",SplitType2.TF_RECORD="TFRecord"})(SplitType=exports.SplitType||(exports.SplitType={}));var AssembleWith;(function(AssembleWith2){AssembleWith2.NONE="None",AssembleWith2.LINE="Line"})(AssembleWith=exports.AssembleWith||(exports.AssembleWith={}));class StandardDockerImage extends DockerImage{constructor(opts){super(),this.allowAnyEcrImagePull=!!opts.allowAnyEcrImagePull,this.imageUri=opts.imageUri,this.repository=opts.repository}bind(task){return this.repository&&this.repository.grantPull(task),this.allowAnyEcrImagePull&&task.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({actions:["ecr:BatchCheckLayerAvailability","ecr:GetDownloadUrlForLayer","ecr:BatchGetImage"],resources:["*"]})),{imageUri:this.imageUri}}}class StandardS3Location extends S3Location{constructor(opts){super(),this.bucket=opts.bucket,this.keyGlob=`${opts.keyPrefix||""}*`,this.uri=opts.uri}bind(task,opts){if(this.bucket)opts.forReading&&this.bucket.grantRead(task,this.keyGlob),opts.forWriting&&this.bucket.grantWrite(task,this.keyGlob);else{const actions=new Array;opts.forReading&&actions.push("s3:GetObject","s3:ListBucket"),opts.forWriting&&actions.push("s3:PutObject"),task.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({actions,resources:["*"]}))}return{uri:this.uri}}}
