"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SecretRotation=exports.SecretRotationApplication=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../aws-ec2"),lambda=require("../../aws-lambda"),serverless=require("../../aws-sam"),core_1=require("../../core"),constructs_1=require("constructs");class SecretRotationApplication{constructor(applicationId,semanticVersion,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_SecretRotationApplicationOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SecretRotationApplication),error}this.applicationId=`arn:aws:serverlessrepo:us-east-1:297356227824:applications/${applicationId}`,this.semanticVersion=semanticVersion,this.applicationName=applicationId,this.isMultiUser=options&&options.isMultiUser}applicationArnForPartition(partition){if(partition==="aws")return this.applicationId;if(partition==="aws-cn")return`arn:aws-cn:serverlessrepo:cn-north-1:193023089310:applications/${this.applicationName}`;if(partition==="aws-us-gov")return`arn:aws-us-gov:serverlessrepo:us-gov-west-1:023102451235:applications/${this.applicationName}`;throw new Error(`unsupported partition: ${partition}`)}semanticVersionForPartition(partition){if(partition==="aws")return this.semanticVersion;if(partition==="aws-cn")return"1.1.37";if(partition==="aws-us-gov")return"1.1.93";throw new Error(`unsupported partition: ${partition}`)}}exports.SecretRotationApplication=SecretRotationApplication,_a=JSII_RTTI_SYMBOL_1,SecretRotationApplication[_a]={fqn:"aws-cdk-lib.aws_secretsmanager.SecretRotationApplication",version:"2.69.0"},SecretRotationApplication.MARIADB_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRDSMariaDBRotationSingleUser","1.1.225"),SecretRotationApplication.MARIADB_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRDSMariaDBRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRDSMySQLRotationSingleUser","1.1.225"),SecretRotationApplication.MYSQL_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRDSMySQLRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.ORACLE_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRDSOracleRotationSingleUser","1.1.225"),SecretRotationApplication.ORACLE_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRDSOracleRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRDSPostgreSQLRotationSingleUser","1.1.225"),SecretRotationApplication.POSTGRES_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRDSPostgreSQLRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.SQLSERVER_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRDSSQLServerRotationSingleUser","1.1.225"),SecretRotationApplication.SQLSERVER_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRDSSQLServerRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.REDSHIFT_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerRedshiftRotationSingleUser","1.1.225"),SecretRotationApplication.REDSHIFT_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerRedshiftRotationMultiUser","1.1.225",{isMultiUser:!0}),SecretRotationApplication.MONGODB_ROTATION_SINGLE_USER=new SecretRotationApplication("SecretsManagerMongoDBRotationSingleUser","1.1.225"),SecretRotationApplication.MONGODB_ROTATION_MULTI_USER=new SecretRotationApplication("SecretsManagerMongoDBRotationMultiUser","1.1.225",{isMultiUser:!0});class SecretRotation extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_SecretRotationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SecretRotation),error}if(!props.target.connections.defaultPort)throw new Error("The `target` connections must have a default port range.");if(props.application.isMultiUser&&!props.masterSecret)throw new Error("The `masterSecret` must be specified for application using the multi user scheme.");const uniqueId=core_1.Names.uniqueId(this),rotationFunctionName=uniqueId.substring(Math.max(uniqueId.length-64,0),uniqueId.length),securityGroup=props.securityGroup||new ec2.SecurityGroup(this,"SecurityGroup",{vpc:props.vpc});props.target.connections.allowDefaultPortFrom(securityGroup);const parameters={endpoint:`https://${props.endpoint?`${props.endpoint.vpcEndpointId}.`:""}secretsmanager.${core_1.Stack.of(this).region}.${core_1.Stack.of(this).urlSuffix}`,functionName:rotationFunctionName,vpcSubnetIds:props.vpc.selectSubnets(props.vpcSubnets).subnetIds.join(","),vpcSecurityGroupIds:securityGroup.securityGroupId};props.excludeCharacters!==void 0&&(parameters.excludeCharacters=props.excludeCharacters),props.secret.encryptionKey&&(parameters.kmsKeyArn=props.secret.encryptionKey.keyArn),props.masterSecret&&(parameters.masterSecretArn=props.masterSecret.secretArn,props.masterSecret.encryptionKey&&(parameters.masterSecretKmsKeyArn=props.masterSecret.encryptionKey.keyArn));const sarMapping=new core_1.CfnMapping(this,"SARMapping",{mapping:{aws:{applicationId:props.application.applicationArnForPartition("aws"),semanticVersion:props.application.semanticVersionForPartition("aws")},"aws-cn":{applicationId:props.application.applicationArnForPartition("aws-cn"),semanticVersion:props.application.semanticVersionForPartition("aws-cn")},"aws-us-gov":{applicationId:props.application.applicationArnForPartition("aws-us-gov"),semanticVersion:props.application.semanticVersionForPartition("aws-us-gov")}}}),application=new serverless.CfnApplication(this,"Resource",{location:{applicationId:sarMapping.findInMap(core_1.Aws.PARTITION,"applicationId"),semanticVersion:sarMapping.findInMap(core_1.Aws.PARTITION,"semanticVersion")},parameters});application.applyRemovalPolicy(core_1.RemovalPolicy.DESTROY);const rotationLambda=lambda.Function.fromFunctionArn(this,"RotationLambda",core_1.Token.asString(application.getAtt("Outputs.RotationLambdaARN")));props.secret.addRotationSchedule("RotationSchedule",{rotationLambda,automaticallyAfter:props.automaticallyAfter}),props.masterSecret&&props.masterSecret.denyAccountRootDelete()}}exports.SecretRotation=SecretRotation,_b=JSII_RTTI_SYMBOL_1,SecretRotation[_b]={fqn:"aws-cdk-lib.aws_secretsmanager.SecretRotation",version:"2.69.0"};
