"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.TmpfsMountOption=exports.DevicePermission=exports.Capability=exports.LinuxParameters=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),constructs_1=require("constructs");class LinuxParameters extends constructs_1.Construct{constructor(scope,id,props={}){super(scope,id),this.capAdd=new Array,this.capDrop=new Array,this.devices=new Array,this.tmpfs=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_LinuxParametersProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LinuxParameters),error}this.validateProps(props),this.sharedMemorySize=props.sharedMemorySize,this.initProcessEnabled=props.initProcessEnabled,this.maxSwap=props.maxSwap,this.swappiness=props.maxSwap?props.swappiness:void 0}validateProps(props){if(!cdk.Token.isUnresolved(props.sharedMemorySize)&&props.sharedMemorySize!==void 0&&(!Number.isInteger(props.sharedMemorySize)||props.sharedMemorySize<0))throw new Error(`sharedMemorySize: Must be an integer greater than 0; received ${props.sharedMemorySize}.`);if(!cdk.Token.isUnresolved(props.swappiness)&&props.swappiness!==void 0&&(!Number.isInteger(props.swappiness)||props.swappiness<0||props.swappiness>100))throw new Error(`swappiness: Must be an integer between 0 and 100; received ${props.swappiness}.`)}addCapabilities(...cap){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Capability(cap)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addCapabilities),error}this.capAdd.push(...cap)}dropCapabilities(...cap){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Capability(cap)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.dropCapabilities),error}this.capDrop.push(...cap)}addDevices(...device){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Device(device)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDevices),error}this.devices.push(...device)}addTmpfs(...tmpfs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecs_Tmpfs(tmpfs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTmpfs),error}this.tmpfs.push(...tmpfs)}renderLinuxParameters(){return{initProcessEnabled:this.initProcessEnabled,sharedMemorySize:this.sharedMemorySize,maxSwap:this.maxSwap?.toMebibytes(),swappiness:this.swappiness,capabilities:{add:cdk.Lazy.list({produce:()=>this.capAdd},{omitEmpty:!0}),drop:cdk.Lazy.list({produce:()=>this.capDrop},{omitEmpty:!0})},devices:cdk.Lazy.any({produce:()=>this.devices.map(renderDevice)},{omitEmptyArray:!0}),tmpfs:cdk.Lazy.any({produce:()=>this.tmpfs.map(renderTmpfs)},{omitEmptyArray:!0})}}}exports.LinuxParameters=LinuxParameters,_a=JSII_RTTI_SYMBOL_1,LinuxParameters[_a]={fqn:"aws-cdk-lib.aws_ecs.LinuxParameters",version:"2.69.0"};function renderDevice(device){return{containerPath:device.containerPath,hostPath:device.hostPath,permissions:device.permissions}}function renderTmpfs(tmpfs){return{containerPath:tmpfs.containerPath,size:tmpfs.size,mountOptions:tmpfs.mountOptions}}var Capability;(function(Capability2){Capability2.ALL="ALL",Capability2.AUDIT_CONTROL="AUDIT_CONTROL",Capability2.AUDIT_WRITE="AUDIT_WRITE",Capability2.BLOCK_SUSPEND="BLOCK_SUSPEND",Capability2.CHOWN="CHOWN",Capability2.DAC_OVERRIDE="DAC_OVERRIDE",Capability2.DAC_READ_SEARCH="DAC_READ_SEARCH",Capability2.FOWNER="FOWNER",Capability2.FSETID="FSETID",Capability2.IPC_LOCK="IPC_LOCK",Capability2.IPC_OWNER="IPC_OWNER",Capability2.KILL="KILL",Capability2.LEASE="LEASE",Capability2.LINUX_IMMUTABLE="LINUX_IMMUTABLE",Capability2.MAC_ADMIN="MAC_ADMIN",Capability2.MAC_OVERRIDE="MAC_OVERRIDE",Capability2.MKNOD="MKNOD",Capability2.NET_ADMIN="NET_ADMIN",Capability2.NET_BIND_SERVICE="NET_BIND_SERVICE",Capability2.NET_BROADCAST="NET_BROADCAST",Capability2.NET_RAW="NET_RAW",Capability2.SETFCAP="SETFCAP",Capability2.SETGID="SETGID",Capability2.SETPCAP="SETPCAP",Capability2.SETUID="SETUID",Capability2.SYS_ADMIN="SYS_ADMIN",Capability2.SYS_BOOT="SYS_BOOT",Capability2.SYS_CHROOT="SYS_CHROOT",Capability2.SYS_MODULE="SYS_MODULE",Capability2.SYS_NICE="SYS_NICE",Capability2.SYS_PACCT="SYS_PACCT",Capability2.SYS_PTRACE="SYS_PTRACE",Capability2.SYS_RAWIO="SYS_RAWIO",Capability2.SYS_RESOURCE="SYS_RESOURCE",Capability2.SYS_TIME="SYS_TIME",Capability2.SYS_TTY_CONFIG="SYS_TTY_CONFIG",Capability2.SYSLOG="SYSLOG",Capability2.WAKE_ALARM="WAKE_ALARM"})(Capability=exports.Capability||(exports.Capability={}));var DevicePermission;(function(DevicePermission2){DevicePermission2.READ="read",DevicePermission2.WRITE="write",DevicePermission2.MKNOD="mknod"})(DevicePermission=exports.DevicePermission||(exports.DevicePermission={}));var TmpfsMountOption;(function(TmpfsMountOption2){TmpfsMountOption2.DEFAULTS="defaults",TmpfsMountOption2.RO="ro",TmpfsMountOption2.RW="rw",TmpfsMountOption2.SUID="suid",TmpfsMountOption2.NOSUID="nosuid",TmpfsMountOption2.DEV="dev",TmpfsMountOption2.NODEV="nodev",TmpfsMountOption2.EXEC="exec",TmpfsMountOption2.NOEXEC="noexec",TmpfsMountOption2.SYNC="sync",TmpfsMountOption2.ASYNC="async",TmpfsMountOption2.DIRSYNC="dirsync",TmpfsMountOption2.REMOUNT="remount",TmpfsMountOption2.MAND="mand",TmpfsMountOption2.NOMAND="nomand",TmpfsMountOption2.ATIME="atime",TmpfsMountOption2.NOATIME="noatime",TmpfsMountOption2.DIRATIME="diratime",TmpfsMountOption2.NODIRATIME="nodiratime",TmpfsMountOption2.BIND="bind",TmpfsMountOption2.RBIND="rbind",TmpfsMountOption2.UNBINDABLE="unbindable",TmpfsMountOption2.RUNBINDABLE="runbindable",TmpfsMountOption2.PRIVATE="private",TmpfsMountOption2.RPRIVATE="rprivate",TmpfsMountOption2.SHARED="shared",TmpfsMountOption2.RSHARED="rshared",TmpfsMountOption2.SLAVE="slave",TmpfsMountOption2.RSLAVE="rslave",TmpfsMountOption2.RELATIME="relatime",TmpfsMountOption2.NORELATIME="norelatime",TmpfsMountOption2.STRICTATIME="strictatime",TmpfsMountOption2.NOSTRICTATIME="nostrictatime",TmpfsMountOption2.MODE="mode",TmpfsMountOption2.UID="uid",TmpfsMountOption2.GID="gid",TmpfsMountOption2.NR_INODES="nr_inodes",TmpfsMountOption2.NR_BLOCKS="nr_blocks",TmpfsMountOption2.MPOL="mpol"})(TmpfsMountOption=exports.TmpfsMountOption||(exports.TmpfsMountOption={}));
