"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SecurityGroup=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cxschema=require("../../cloud-assembly-schema"),core_1=require("../../core"),connections_1=require("./connections"),ec2_generated_1=require("./ec2.generated"),peer_1=require("./peer"),port_1=require("./port"),SECURITY_GROUP_SYMBOL=Symbol.for("@aws-cdk/iam.SecurityGroup"),SECURITY_GROUP_DISABLE_INLINE_RULES_CONTEXT_KEY="@aws-cdk/aws-ec2.securityGroupDisableInlineRules";class SecurityGroupBase extends core_1.Resource{constructor(scope,id,props){super(scope,id,props),this.canInlineRule=!1,this.connections=new connections_1.Connections({securityGroups:[this]}),this.peerAsTokenCount=0,Object.defineProperty(this,SECURITY_GROUP_SYMBOL,{value:!0})}static isSecurityGroup(x){return SECURITY_GROUP_SYMBOL in x}get uniqueId(){return core_1.Names.nodeUniqueId(this.node)}addIngressRule(peer,connection,description,remoteRule){description===void 0&&(description=`from ${peer.uniqueId}:${connection}`);const[scope,id]=this.determineRuleScope(peer,connection,"from",remoteRule);scope.node.tryFindChild(id)===void 0&&new ec2_generated_1.CfnSecurityGroupIngress(scope,id,{groupId:this.securityGroupId,...peer.toIngressRuleConfig(),...connection.toRuleJson(),description})}addEgressRule(peer,connection,description,remoteRule){description===void 0&&(description=`to ${peer.uniqueId}:${connection}`);const[scope,id]=this.determineRuleScope(peer,connection,"to",remoteRule);scope.node.tryFindChild(id)===void 0&&new ec2_generated_1.CfnSecurityGroupEgress(scope,id,{groupId:this.securityGroupId,...peer.toEgressRuleConfig(),...connection.toRuleJson(),description})}toIngressRuleConfig(){return{sourceSecurityGroupId:this.securityGroupId}}toEgressRuleConfig(){return{destinationSecurityGroupId:this.securityGroupId}}determineRuleScope(peer,connection,fromTo,remoteRule){if(remoteRule&&SecurityGroupBase.isSecurityGroup(peer)&&differentStacks(this,peer)){const reversedFromTo=fromTo==="from"?"to":"from";return[peer,`${this.uniqueId}:${connection} ${reversedFromTo}`]}else return[this,`${fromTo} ${this.renderPeer(peer)}:${connection}`.replace("/","_")]}renderPeer(peer){return core_1.Token.isUnresolved(peer.uniqueId)?this.peerAsTokenCount++?`'{IndirectPeer${this.peerAsTokenCount}}'`:"{IndirectPeer}":peer.uniqueId}}function differentStacks(group1,group2){return core_1.Stack.of(group1)!==core_1.Stack.of(group2)}class SecurityGroup extends SecurityGroupBase{constructor(scope,id,props){super(scope,id,{physicalName:props.securityGroupName}),this.directIngressRules=[],this.directEgressRules=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_SecurityGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SecurityGroup),error}const groupDescription=props.description||this.node.path;this.allowAllOutbound=props.allowAllOutbound!==!1,this.allowAllIpv6Outbound=props.allowAllIpv6Outbound??!1,this.disableInlineRules=props.disableInlineRules!==void 0?!!props.disableInlineRules:!!this.node.tryGetContext(SECURITY_GROUP_DISABLE_INLINE_RULES_CONTEXT_KEY),this.securityGroup=new ec2_generated_1.CfnSecurityGroup(this,"Resource",{groupName:this.physicalName,groupDescription,securityGroupIngress:core_1.Lazy.any({produce:()=>this.directIngressRules},{omitEmptyArray:!0}),securityGroupEgress:core_1.Lazy.any({produce:()=>this.directEgressRules},{omitEmptyArray:!0}),vpcId:props.vpc.vpcId}),this.securityGroupId=this.securityGroup.attrGroupId,this.securityGroupVpcId=this.securityGroup.attrVpcId,this.securityGroupName=this.securityGroup.ref,this.addDefaultEgressRule(),this.addDefaultIpv6EgressRule()}static fromLookup(scope,id,securityGroupId){return this.fromLookupAttributes(scope,id,{securityGroupId})}static fromLookupById(scope,id,securityGroupId){return this.fromLookupAttributes(scope,id,{securityGroupId})}static fromLookupByName(scope,id,securityGroupName,vpc){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IVpc(vpc)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookupByName),error}return this.fromLookupAttributes(scope,id,{securityGroupName,vpc})}static fromSecurityGroupId(scope,id,securityGroupId,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_SecurityGroupImportOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecurityGroupId),error}class MutableImport extends SecurityGroupBase{constructor(){super(...arguments),this.securityGroupId=securityGroupId,this.allowAllOutbound=options.allowAllOutbound??!0,this.allowAllIpv6Outbound=options.allowAllIpv6Outbound??!1}addEgressRule(peer,connection,description,remoteRule){options.allowAllOutbound===!1&&super.addEgressRule(peer,connection,description,remoteRule)}}class ImmutableImport extends SecurityGroupBase{constructor(){super(...arguments),this.securityGroupId=securityGroupId,this.allowAllOutbound=options.allowAllOutbound??!0,this.allowAllIpv6Outbound=options.allowAllIpv6Outbound??!1}addEgressRule(_peer,_connection,_description,_remoteRule){}addIngressRule(_peer,_connection,_description,_remoteRule){}}return options.mutable!==!1?new MutableImport(scope,id):new ImmutableImport(scope,id)}static fromLookupAttributes(scope,id,options){if(core_1.Token.isUnresolved(options.securityGroupId)||core_1.Token.isUnresolved(options.securityGroupName)||core_1.Token.isUnresolved(options.vpc?.vpcId))throw new Error("All arguments to look up a security group must be concrete (no Tokens)");const attributes=core_1.ContextProvider.getValue(scope,{provider:cxschema.ContextProvider.SECURITY_GROUP_PROVIDER,props:{securityGroupId:options.securityGroupId,securityGroupName:options.securityGroupName,vpcId:options.vpc?.vpcId},dummyValue:{securityGroupId:"sg-12345678",allowAllOutbound:!0}}).value;return SecurityGroup.fromSecurityGroupId(scope,id,attributes.securityGroupId,{allowAllOutbound:attributes.allowAllOutbound,mutable:!0})}addIngressRule(peer,connection,description,remoteRule){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IPeer(peer),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_Port(connection)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addIngressRule),error}if(!peer.canInlineRule||!connection.canInlineRule||this.disableInlineRules){super.addIngressRule(peer,connection,description,remoteRule);return}description===void 0&&(description=`from ${peer.uniqueId}:${connection}`),this.addDirectIngressRule({...peer.toIngressRuleConfig(),...connection.toRuleJson(),description})}addEgressRule(peer,connection,description,remoteRule){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IPeer(peer),jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_Port(connection)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addEgressRule),error}const isIpv6=peer.toEgressRuleConfig().hasOwnProperty("cidrIpv6");if(!isIpv6&&this.allowAllOutbound){remoteRule||core_1.Annotations.of(this).addWarning("Ignoring Egress rule since 'allowAllOutbound' is set to true; To add customized rules, set allowAllOutbound=false on the SecurityGroup");return}else!isIpv6&&!this.allowAllOutbound&&this.removeNoTrafficRule();if(isIpv6&&this.allowAllIpv6Outbound){remoteRule||core_1.Annotations.of(this).addWarning("Ignoring Egress rule since 'allowAllIpv6Outbound' is set to true; To add customized rules, set allowAllIpv6Outbound=false on the SecurityGroup");return}if(!peer.canInlineRule||!connection.canInlineRule||this.disableInlineRules){super.addEgressRule(peer,connection,description,remoteRule);return}description===void 0&&(description=`from ${peer.uniqueId}:${connection}`);const rule={...peer.toEgressRuleConfig(),...connection.toRuleJson(),description};if(isAllTrafficRule(rule))throw new Error('Cannot add an "all traffic" egress rule in this way; set allowAllOutbound=true (for ipv6) or allowAllIpv6Outbound=true (for ipv6) on the SecurityGroup instead.');this.addDirectEgressRule(rule)}addDirectIngressRule(rule){this.hasIngressRule(rule)||this.directIngressRules.push(rule)}hasIngressRule(rule){return this.directIngressRules.findIndex(r=>ingressRulesEqual(r,rule))>-1}addDirectEgressRule(rule){this.hasEgressRule(rule)||this.directEgressRules.push(rule)}hasEgressRule(rule){return this.directEgressRules.findIndex(r=>egressRulesEqual(r,rule))>-1}addDefaultEgressRule(){if(this.disableInlineRules){const peer=this.allowAllOutbound?ALL_TRAFFIC_PEER:NO_TRAFFIC_PEER,port=this.allowAllOutbound?ALL_TRAFFIC_PORT:NO_TRAFFIC_PORT,description=this.allowAllOutbound?ALLOW_ALL_RULE.description:MATCH_NO_TRAFFIC.description;super.addEgressRule(peer,port,description,!1)}else{const rule=this.allowAllOutbound?ALLOW_ALL_RULE:MATCH_NO_TRAFFIC;this.directEgressRules.push(rule)}}addDefaultIpv6EgressRule(){const description="Allow all outbound ipv6 traffic by default",peer=peer_1.Peer.anyIpv6();this.allowAllIpv6Outbound&&(this.disableInlineRules?super.addEgressRule(peer,port_1.Port.allTraffic(),description,!1):this.directEgressRules.push({ipProtocol:"-1",cidrIpv6:peer.uniqueId,description}))}removeNoTrafficRule(){if(this.disableInlineRules){const[scope,id]=this.determineRuleScope(NO_TRAFFIC_PEER,NO_TRAFFIC_PORT,"to",!1);scope.node.tryRemoveChild(id)}else{const i=this.directEgressRules.findIndex(r=>egressRulesEqual(r,MATCH_NO_TRAFFIC));i>-1&&this.directEgressRules.splice(i,1)}}}exports.SecurityGroup=SecurityGroup,_a=JSII_RTTI_SYMBOL_1,SecurityGroup[_a]={fqn:"aws-cdk-lib.aws_ec2.SecurityGroup",version:"2.69.0"};const MATCH_NO_TRAFFIC={cidrIp:"255.255.255.255/32",description:"Disallow all traffic",ipProtocol:"icmp",fromPort:252,toPort:86},NO_TRAFFIC_PEER=peer_1.Peer.ipv4(MATCH_NO_TRAFFIC.cidrIp),NO_TRAFFIC_PORT=port_1.Port.icmpTypeAndCode(MATCH_NO_TRAFFIC.fromPort,MATCH_NO_TRAFFIC.toPort),ALLOW_ALL_RULE={cidrIp:"0.0.0.0/0",description:"Allow all outbound traffic by default",ipProtocol:"-1"},ALL_TRAFFIC_PEER=peer_1.Peer.anyIpv4(),ALL_TRAFFIC_PORT=port_1.Port.allTraffic();function ingressRulesEqual(a,b){return a.cidrIp===b.cidrIp&&a.cidrIpv6===b.cidrIpv6&&a.fromPort===b.fromPort&&a.toPort===b.toPort&&a.ipProtocol===b.ipProtocol&&a.sourceSecurityGroupId===b.sourceSecurityGroupId&&a.sourceSecurityGroupName===b.sourceSecurityGroupName&&a.sourceSecurityGroupOwnerId===b.sourceSecurityGroupOwnerId}function egressRulesEqual(a,b){return a.cidrIp===b.cidrIp&&a.cidrIpv6===b.cidrIpv6&&a.fromPort===b.fromPort&&a.toPort===b.toPort&&a.ipProtocol===b.ipProtocol&&a.destinationPrefixListId===b.destinationPrefixListId&&a.destinationSecurityGroupId===b.destinationSecurityGroupId}function isAllTrafficRule(rule){return(rule.cidrIp==="0.0.0.0/0"||rule.cidrIpv6==="::/0")&&rule.ipProtocol==="-1"}
