"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const codebuild=require("../../aws-codebuild"),codecommit=require("../../aws-codecommit"),codepipeline=require("../../aws-codepipeline"),lambda=require("../../aws-lambda"),cdk=require("../../core"),codepipeline_actions=require("../lib"),app=new cdk.App,lambdaStack=new cdk.Stack(app,"LambdaStack"),lambdaCode=lambda.Code.fromCfnParameters();new lambda.Function(lambdaStack,"Lambda",{code:lambdaCode,handler:"index.handler",runtime:lambda.Runtime.NODEJS_14_X});const pipelineStack=new cdk.Stack(app,"PipelineStack"),pipeline=new codepipeline.Pipeline(pipelineStack,"Pipeline"),cdkSourceOutput=new codepipeline.Artifact,cdkSourceAction=new codepipeline_actions.CodeCommitSourceAction({repository:new codecommit.Repository(pipelineStack,"CdkCodeRepo",{repositoryName:"CdkCodeRepo"}),actionName:"CdkCode_Source",output:cdkSourceOutput}),lambdaSourceOutput=new codepipeline.Artifact,lambdaSourceAction=new codepipeline_actions.CodeCommitSourceAction({repository:new codecommit.Repository(pipelineStack,"LambdaCodeRepo",{repositoryName:"LambdaCodeRepo"}),actionName:"LambdaCode_Source",output:lambdaSourceOutput});pipeline.addStage({stageName:"Source",actions:[cdkSourceAction,lambdaSourceAction]});const cdkBuildProject=new codebuild.Project(pipelineStack,"CdkBuildProject",{environment:{buildImage:codebuild.LinuxBuildImage.UBUNTU_14_04_NODEJS_10_1_0},buildSpec:codebuild.BuildSpec.fromObject({version:"0.2",phases:{install:{commands:"npm install"},build:{commands:["npm run build","npm run cdk synth LambdaStack -- -o ."]}},artifacts:{files:"LambdaStack.template.yaml"}})}),cdkBuildOutput=new codepipeline.Artifact,cdkBuildAction=new codepipeline_actions.CodeBuildAction({actionName:"CDK_Build",project:cdkBuildProject,input:cdkSourceOutput,outputs:[cdkBuildOutput]}),lambdaBuildProject=new codebuild.Project(pipelineStack,"LambdaBuildProject",{environment:{buildImage:codebuild.LinuxBuildImage.UBUNTU_14_04_NODEJS_10_1_0},buildSpec:codebuild.BuildSpec.fromObject({version:"0.2",phases:{install:{commands:"npm install"},build:{commands:"npm run build"}},artifacts:{files:["index.js","node_modules/**/*"]}})}),lambdaBuildOutput=new codepipeline.Artifact,lambdaBuildAction=new codepipeline_actions.CodeBuildAction({actionName:"Lambda_Build",project:lambdaBuildProject,input:lambdaSourceOutput,outputs:[lambdaBuildOutput]});pipeline.addStage({stageName:"Build",actions:[cdkBuildAction,lambdaBuildAction]}),pipeline.addStage({stageName:"Deploy",actions:[new codepipeline_actions.CloudFormationCreateUpdateStackAction({actionName:"Lambda_CFN_Deploy",templatePath:cdkBuildOutput.atPath("LambdaStack.template.yaml"),stackName:"LambdaStackDeployedName",adminPermissions:!0,parameterOverrides:lambdaCode.assign(lambdaBuildOutput.s3Location),extraInputs:[lambdaBuildOutput]})]});
