from typing import TypeVar

from java.lang import AutoCloseable, Runnable
from java.util import Iterator, Spliterator
from java.util.function import Consumer

S = TypeVar("S")
T = TypeVar("T")

class BaseStream(AutoCloseable):
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def iterator(self) -> Iterator: ...
    def onClose(self, closeHandler: Runnable) -> S: ...
    def parallel(self) -> S: ...
    def sequential(self) -> S: ...
    def spliterator(self) -> Spliterator: ...
    def unordered(self) -> S: ...

class Stream(BaseStream):
    @staticmethod
    def builder() -> Stream.Builder: ...
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def iterator(self) -> Iterator: ...
    def onClose(self, closeHandler: Runnable) -> S: ...
    def parallel(self) -> S: ...
    def sequential(self) -> S: ...
    def spliterator(self) -> Spliterator: ...
    def unordered(self) -> S: ...

    class Builder(Consumer):
        def accept(self, t: T) -> None: ...
        def add(self, t: T) -> Stream.Builder: ...
        def build(self) -> None: ...
