from typing import List, TypeVar

from java.lang import Enum, Object, String
from java.security import Principal
from java.time import Instant
from java.util.concurrent import TimeUnit

T = TypeVar("T")

class AttributeView:
    def name(self) -> String: ...

class BasicFileAttributes:
    def creationTime(self) -> FileTime: ...
    def fileKey(self) -> Object: ...
    def isDirectory(self) -> bool: ...
    def isOther(self) -> bool: ...
    def isRegularFile(self) -> bool: ...
    def isSymbolicLink(self) -> bool: ...
    def lastAccessTime(self) -> FileTime: ...
    def lastModifiedTime(self) -> FileTime: ...
    def size(self) -> long: ...

class FileAttribute:
    def name(self) -> String: ...
    def value(self) -> T: ...

class FileAttributeView(AttributeView):
    def name(self) -> String: ...

class FileTime(Object):
    def compareTo(self, other: FileTime) -> int: ...
    @staticmethod
    def fromMillis(value: long) -> FileTime: ...
    def to(self, unit: TimeUnit) -> long: ...
    def toInstant(self) -> Instant: ...
    def toMillis(self) -> long: ...

class PosixFilePermission(Enum):
    GROUP_EXECUTE: PosixFilePermission
    GROUP_READ: PosixFilePermission
    GROUP_WRITE: PosixFilePermission
    OTHERS_EXECUTE: PosixFilePermission
    OTHERS_READ: PosixFilePermission
    OTHERS_WRITE: PosixFilePermission
    OWNER_EXECUTE: PosixFilePermission
    OWNER_READ: PosixFilePermission
    OWNER_WRITE: PosixFilePermission
    @staticmethod
    def values() -> List[PosixFilePermission]: ...

class UserPrincipal(Principal):
    def equals(self, another: Object) -> bool: ...
    def getName(self) -> String: ...
    def hashCode(self) -> int: ...
    def toString(self) -> String: ...

class FileStoreAttributeView(AttributeView):
    def name(self) -> String: ...
