from typing import Any, Optional, Tuple, Union

from java.io import InputStream
from java.lang import Object, String

class ApplicationScope(Object):
    ALL: int
    CLIENT: int
    DESIGNER: int
    GATEWAY: int
    NONE: int
    @staticmethod
    def getGlobalScope() -> int: ...
    @staticmethod
    def getScopePrefix() -> String: ...
    @staticmethod
    def init(globalScope: int) -> None: ...
    @staticmethod
    def isClient(scope: int) -> bool: ...
    @staticmethod
    def isDesigner(scope: int) -> bool: ...
    @staticmethod
    def isGateway(scope: int) -> bool: ...
    @staticmethod
    def parseScope(s: String) -> int: ...
    @staticmethod
    def toCode(scope: int) -> String: ...

class Version(Object):
    build: int
    dev: bool
    major: int
    minor: int
    rev: int
    beta: int
    rc: int
    snapshot: bool
    def __init__(
        self,
        major: int = ...,
        minor: int = ...,
        rev: int = ...,
        build: int = ...,
        beta: int = ...,
        rc: int = ...,
    ) -> None: ...
    def __eq__(self, other: Any) -> bool: ...
    def compareTo(self, that: Version) -> Optional[int]: ...
    def exists(self) -> bool: ...
    @staticmethod
    def fromXML(inputStream: InputStream) -> Version: ...
    def getBasicString(self) -> str: ...
    def getBeta(self) -> int: ...
    def getBuildNumber(self) -> int: ...
    def getMajor(self) -> int: ...
    def getMinor(self) -> int: ...
    def getRc(self) -> int: ...
    def getRevision(self) -> int: ...
    def getXML(self) -> str: ...
    def isDev(self) -> bool: ...
    def isFutureVersion(self, arg: Union[Version, String]) -> bool: ...
    def isSnapshot(self) -> bool: ...
    @staticmethod
    def parse(s: String) -> Version: ...
    def toParseableString(self) -> str: ...
    def toString(self) -> str: ...
    def toTuple(self, strict: bool = ...) -> Tuple[int, ...]: ...
