# Radial Hydride Code

This is a Python package developed to aid in the charactacterisation and quantification of hydrides from micrographs. The main functions of this package are to: 
- Determine the Radial Hydride Fraction (RHF)
- Characterise the extent of branching
- Determine the most probable crack path within a micrograph

## **How to install**

- `pip install RHaP==0.1`

## **How to use**

- Enter `jupyter lab` into the anaconda terminal and Jupyter lab will open in your browser.
- Open the example notebook, provided with the folder downloaded earlier.
- Examples of how to use the software are included, as well as an example micrograph.

## **Documentation**

- For more help, browse the documentation in the /docs directory.

## **Credits**

The software uses the following open source packages:

- [jupyter-notebook](http://jupyter.org/)
- [numpy](http://numpy.org/)
- [matplotlib](http://matplotlib.org/)
- [scikit-image](http://scikit-image.org/)
- [scipy](https://scipy.org/scipylib/)
- [numba](https://numba.pydata.org)
- [skan](https://jni.github.io/skan/)
- [networkx](https://networkx.org/)
- [toolz](https://github.com/pytoolz/toolz/)
- [matplotlib-scalebar](https://pypi.org/project/matplotlib-scalebar/)

## **Contacts** 

- Mia Maric (mia.maric@manchester.ac.uk)
- Dr Pratheek Shanthraj (pratheek.shanthraj@manchester.ac.uk)
- Dr Rhys Thomas (rhys.thomas@manchester.ac.uk)
- Dr Michael Atkinson (michael.atkinson@manchester.ac.uk)
