"""
Type annotations for sagemaker-geospatial service literal definitions.

[Open documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_geospatial/literals/)

Usage::

    ```python
    from mypy_boto3_sagemaker_geospatial.literals import AlgorithmNameCloudRemovalType

    data: AlgorithmNameCloudRemovalType = "INTERPOLATION"
    ```
"""
import sys

if sys.version_info >= (3, 9):
    from typing import Literal
else:
    from typing_extensions import Literal

__all__ = (
    "AlgorithmNameCloudRemovalType",
    "AlgorithmNameGeoMosaicType",
    "AlgorithmNameResamplingType",
    "ComparisonOperatorType",
    "DataCollectionTypeType",
    "EarthObservationJobErrorTypeType",
    "EarthObservationJobExportStatusType",
    "EarthObservationJobStatusType",
    "ExportErrorTypeType",
    "GroupByType",
    "ListEarthObservationJobsPaginatorName",
    "ListRasterDataCollectionsPaginatorName",
    "ListVectorEnrichmentJobsPaginatorName",
    "LogicalOperatorType",
    "MetadataProviderType",
    "OutputTypeType",
    "PredefinedResolutionType",
    "SortOrderType",
    "TargetOptionsType",
    "TemporalStatisticsType",
    "UnitType",
    "VectorEnrichmentJobDocumentTypeType",
    "VectorEnrichmentJobErrorTypeType",
    "VectorEnrichmentJobExportErrorTypeType",
    "VectorEnrichmentJobExportStatusType",
    "VectorEnrichmentJobStatusType",
    "VectorEnrichmentJobTypeType",
    "ZonalStatisticsType",
    "SageMakergeospatialcapabilitiesServiceName",
    "ServiceName",
    "ResourceServiceName",
    "PaginatorName",
    "RegionName",
)

AlgorithmNameCloudRemovalType = Literal["INTERPOLATION"]
AlgorithmNameGeoMosaicType = Literal[
    "AVERAGE",
    "BILINEAR",
    "CUBIC",
    "CUBICSPLINE",
    "LANCZOS",
    "MAX",
    "MED",
    "MIN",
    "MODE",
    "NEAR",
    "Q1",
    "Q3",
    "RMS",
    "SUM",
]
AlgorithmNameResamplingType = Literal[
    "AVERAGE",
    "BILINEAR",
    "CUBIC",
    "CUBICSPLINE",
    "LANCZOS",
    "MAX",
    "MED",
    "MIN",
    "MODE",
    "NEAR",
    "Q1",
    "Q3",
    "RMS",
    "SUM",
]
ComparisonOperatorType = Literal["EQUALS", "NOT_EQUALS", "STARTS_WITH"]
DataCollectionTypeType = Literal["PREMIUM", "PUBLIC", "USER"]
EarthObservationJobErrorTypeType = Literal["CLIENT_ERROR", "SERVER_ERROR"]
EarthObservationJobExportStatusType = Literal["FAILED", "IN_PROGRESS", "SUCCEEDED"]
EarthObservationJobStatusType = Literal[
    "COMPLETED",
    "DELETED",
    "DELETING",
    "FAILED",
    "INITIALIZING",
    "IN_PROGRESS",
    "STOPPED",
    "STOPPING",
]
ExportErrorTypeType = Literal["CLIENT_ERROR", "SERVER_ERROR"]
GroupByType = Literal["ALL", "YEARLY"]
ListEarthObservationJobsPaginatorName = Literal["list_earth_observation_jobs"]
ListRasterDataCollectionsPaginatorName = Literal["list_raster_data_collections"]
ListVectorEnrichmentJobsPaginatorName = Literal["list_vector_enrichment_jobs"]
LogicalOperatorType = Literal["AND"]
MetadataProviderType = Literal["PLANET_ORDER"]
OutputTypeType = Literal["FLOAT32", "FLOAT64", "INT16", "INT32", "UINT16"]
PredefinedResolutionType = Literal["AVERAGE", "HIGHEST", "LOWEST"]
SortOrderType = Literal["ASCENDING", "DESCENDING"]
TargetOptionsType = Literal["INPUT", "OUTPUT"]
TemporalStatisticsType = Literal["MEAN", "MEDIAN", "STANDARD_DEVIATION"]
UnitType = Literal["METERS"]
VectorEnrichmentJobDocumentTypeType = Literal["CSV"]
VectorEnrichmentJobErrorTypeType = Literal["CLIENT_ERROR", "SERVER_ERROR"]
VectorEnrichmentJobExportErrorTypeType = Literal["CLIENT_ERROR", "SERVER_ERROR"]
VectorEnrichmentJobExportStatusType = Literal["FAILED", "IN_PROGRESS", "SUCCEEDED"]
VectorEnrichmentJobStatusType = Literal[
    "COMPLETED",
    "DELETED",
    "DELETING",
    "FAILED",
    "INITIALIZING",
    "IN_PROGRESS",
    "STOPPED",
    "STOPPING",
]
VectorEnrichmentJobTypeType = Literal["MAP_MATCHING", "REVERSE_GEOCODING"]
ZonalStatisticsType = Literal["MAX", "MEAN", "MEDIAN", "MIN", "STANDARD_DEVIATION", "SUM"]
SageMakergeospatialcapabilitiesServiceName = Literal["sagemaker-geospatial"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "alexaforbusiness",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "arc-zonal-shift",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "backup",
    "backup-gateway",
    "backupstorage",
    "batch",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecommit",
    "codedeploy",
    "codeguru-reviewer",
    "codeguruprofiler",
    "codepipeline",
    "codestar",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcases",
    "connectparticipant",
    "controltower",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "es",
    "events",
    "evidently",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "fsx",
    "gamelift",
    "gamesparks",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "honeycode",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector2",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot-roborunner",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "keyspaces",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "m2",
    "machinelearning",
    "macie",
    "macie2",
    "managedblockchain",
    "marketplace-catalog",
    "marketplace-entitlement",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mobile",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "network-firewall",
    "networkmanager",
    "nimble",
    "oam",
    "omics",
    "opensearch",
    "opensearchserverless",
    "opsworks",
    "opsworkscm",
    "organizations",
    "outposts",
    "panorama",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "polly",
    "pricing",
    "privatenetworks",
    "proton",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53resolver",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "simspaceweaver",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "textract",
    "timestream-query",
    "timestream-write",
    "transcribe",
    "transfer",
    "translate",
    "voice-id",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "worklink",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation",
    "cloudwatch",
    "dynamodb",
    "ec2",
    "glacier",
    "iam",
    "opsworks",
    "s3",
    "sns",
    "sqs",
]
PaginatorName = Literal[
    "list_earth_observation_jobs", "list_raster_data_collections", "list_vector_enrichment_jobs"
]
RegionName = Literal["us-west-2"]
