# Probability Distribution Library for Python

[![PyPI](https://img.shields.io/pypi/v/pdlpy)](https://pypi.org/project/pdlpy)
[![Python Version](https://img.shields.io/pypi/pyversions/pdlpy)](https://python.org)
[![Downloads](https://pepy.tech/badge/pdlpy)](https://pepy.tech/project/pdlpy)
[![GitHub Build](https://img.shields.io/github/actions/workflow/status/andrebienemann/pdlpy/ci.yml)](https://github.com/andrebienemann/pdlpy/actions/workflows/ci.yml)
[![Codecov](https://img.shields.io/codecov/c/github/andrebienemann/pdlpy)](https://app.codecov.io/gh/andrebienemann/pdlpy)
[![License](https://img.shields.io/github/license/andrebienemann/pdlpy)](https://github.com/andrebienemann/pdlpy/blob/main/LICENSE)
[![Code Style](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

**Probability Distribution Library for Python** is a library for simulation and analysis of random processes.
It contains classes for descrete and continious distributions as listed below.

Discrete distributions:

- [Bernoulli](https://andrebienemann.github.io/pdlpy/discrete/bernoulli)
- [Binomial](https://andrebienemann.github.io/pdlpy/discrete/binomial)
- [Geometric](https://andrebienemann.github.io/pdlpy/discrete/geometric)
- [Hypergeometric](https://andrebienemann.github.io/pdlpy/discrete/hypergeometric)
- [Poisson](https://andrebienemann.github.io/pdlpy/discrete/poisson)

Continuous distributions:

- [Exponential](https://andrebienemann.github.io/pdlpy/continuous/exponential)
- [Normal](https://andrebienemann.github.io/pdlpy/continuous/normal)
- [Uniform](https://andrebienemann.github.io/pdlpy/continuous/uniform)

## Installation

Install and update using [pip](https://pip.pypa.io/en/stable/getting-started/):

```shell
pip install -U pdlpy
```

## Demo

Create and analyse probability distributions as simple as:

![demo](https://github.com/andrebienemann/pdlpy/blob/main/docs/assets/demo.gif)

## Links

- [Documentation](https://andrebienemann.github.io/pdlpy/)
- [PyPI Releases](https://pypi.org/project/pdlpy/)
- [Source Code](https://github.com/andrebienemann/pdlpy/)
- [Issue Tracker](https://github.com/andrebienemann/pdlpy/issues/)
