TEMPLATES = {
    'main.py': '''# !/usr/bin/env python
"""
Utility for running PyQtier desktop applications.
"""

from app.windows_manager import WindowsManager


def main():
    try:
        from PyQt5 import QtCore
    except ImportError as exc:
        raise ImportError("Couldn't import PyQt5. Are you sure it's installed?") from exc
    wm = WindowsManager()
    wm.show_ui()


if __name__ == '__main__':
    main()
''',

    'app/windows_manager.py': '''from pyqtier import PyQtierWindowsManager

from app.models import SettingsModel
from app.views import Ui_MainWindow
from app.presenters import MainWindowPresenter


class WindowsManager(PyQtierWindowsManager):
    def __init__(self):
        super().__init__()
        self.settings_window = None

    def setup_manager(self):
        self.setup_main_window(Ui_MainWindow, MainWindowPresenter, SettingsModel)

        # Creating windows widgets
        self.settings_window = self.widget_registry.get_initialized_widget('settings_widget')

        self.main_window.register_callback('settings_widget', self.settings_window.open)

        # Adding behaviours to widgets (must be the last section)
        self.main_window.add_behaviour()
    ''',

    'app/models/__init__.py': '''from .settings import SettingsModel''',

    'app/models/settings.py': '''from pyqtier.models import PyQtierSettingsModel


class SettingsModel(PyQtierSettingsModel):
    def __init__(self, settings_id: str = ""):
        super(SettingsModel, self).__init__(settings_id)
''',

    'app/presenters/__init__.py': '''from .main_window_presenter import MainWindowPresenter
from .other_presenters import *
    ''',

    'app/presenters/main_window_presenter.py': '''from pyqtier.presenters import PyQtierMainWindowPresenter


class MainWindowPresenter(PyQtierMainWindowPresenter):
    def add_behaviour(self):
        self.ui.actionSettings.triggered.connect(self.get_callback('settings_widget'))
''',

    'app/presenters/other_presenters.py': '''from app.models.settings import SettingsModel
from app.views import Ui_SimpleView
from pyqtier.registry import PyQtierWindowsRegistry
from pyqtier.presenters import PyQtierSimplePresenter


@PyQtierWindowsRegistry.register("settings_widget", Ui_SimpleView, SettingsModel)
class SettingsWidget(PyQtierSimplePresenter):
    ...
''',

    'app/views/__init__.py': '''from .main_window_interface import Ui_MainWindow
from .simple_interface import Ui_SimpleView
    ''',

    'app/views/simple_interface.py': '''# -*- coding: utf-8 -*-

from PyQt5 import QtCore, QtGui, QtWidgets


class Ui_SimpleView(object):
    def setupUi(self, SimpleView):
        SimpleView.setObjectName("SimpleView")
        SimpleView.resize(400, 300)

        self.retranslateUi(SimpleView)
        QtCore.QMetaObject.connectSlotsByName(SimpleView)

    def retranslateUi(self, SimpleView):
        _translate = QtCore.QCoreApplication.translate
        SimpleView.setWindowTitle(_translate("SimpleView", "SimpleView"))


if __name__ == "__main__":
    import sys
    app = QtWidgets.QApplication(sys.argv)
    SimpleView = QtWidgets.QWidget()
    ui = Ui_SimpleView()
    ui.setupUi(SimpleView)
    SimpleView.show()
    sys.exit(app.exec_())
''',

    'app/views/main_window_interface.py': '''# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'testProject/app/templates/ui/main_window_interface.ui'
#
# Created by: PyQt5 UI code generator 5.15.9
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets


class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(823, 649)
        self.centralwidget = QtWidgets.QWidget(MainWindow)
        self.centralwidget.setObjectName("centralwidget")
        MainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtWidgets.QMenuBar(MainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 823, 24))
        self.menubar.setObjectName("menubar")
        self.menuFile = QtWidgets.QMenu(self.menubar)
        self.menuFile.setObjectName("menuFile")
        MainWindow.setMenuBar(self.menubar)
        self.statusbar = QtWidgets.QStatusBar(MainWindow)
        self.statusbar.setObjectName("statusbar")
        MainWindow.setStatusBar(self.statusbar)
        self.actionSettings = QtWidgets.QAction(MainWindow)
        self.actionSettings.setObjectName("actionSettings")
        self.actionQuit = QtWidgets.QAction(MainWindow)
        self.actionQuit.setObjectName("actionQuit")
        self.menuFile.addAction(self.actionSettings)
        self.menuFile.addSeparator()
        self.menuFile.addAction(self.actionQuit)
        self.menubar.addAction(self.menuFile.menuAction())

        self.retranslateUi(MainWindow)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)

    def retranslateUi(self, MainWindow):
        _translate = QtCore.QCoreApplication.translate
        MainWindow.setWindowTitle(_translate("MainWindow", "PyQtier Main Window"))
        self.menuFile.setTitle(_translate("MainWindow", "File"))
        self.actionSettings.setText(_translate("MainWindow", "Settings"))
        self.actionQuit.setText(_translate("MainWindow", "Quit"))
        self.actionQuit.setShortcut(_translate("MainWindow", "Ctrl+Q"))
''',

    'app/views/templates/main_window_interface.ui': '''<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>MainWindow</class>
 <widget class="QMainWindow" name="MainWindow">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>823</width>
    <height>649</height>
   </rect>
  </property>
  <property name="windowTitle">
   <string>PyQtier Main Window</string>
  </property>
  <widget class="QWidget" name="centralwidget"/>
  <widget class="QMenuBar" name="menubar">
   <property name="geometry">
    <rect>
     <x>0</x>
     <y>0</y>
     <width>823</width>
     <height>24</height>
    </rect>
   </property>
   <widget class="QMenu" name="menuFile">
    <property name="title">
     <string>File</string>
    </property>
    <addaction name="actionSettings"/>
    <addaction name="separator"/>
    <addaction name="actionQuit"/>
   </widget>
   <addaction name="menuFile"/>
  </widget>
  <widget class="QStatusBar" name="statusbar"/>
  <action name="actionSettings">
   <property name="text">
    <string>Settings</string>
   </property>
  </action>
  <action name="actionQuit">
   <property name="text">
    <string>Quit</string>
   </property>
   <property name="shortcut">
    <string>Ctrl+Q</string>
   </property>
  </action>
 </widget>
 <resources/>
 <connections/>
</ui>
''',

    'app/views/templates/simple_interface.ui': '''<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>SimpleView</class>
 <widget class="QWidget" name="SimpleView">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>400</width>
    <height>300</height>
   </rect>
  </property>
  <property name="windowTitle">
   <string>SimpleView</string>
  </property>
 </widget>
 <resources/>
 <connections/>
</ui>'''
}
