import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceJiraConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#api_url ServiceJira#api_url}
    */
    readonly apiUrl?: string;
    /**
    * Enable comments inside Jira issues on each GitLab event (commit / merge request)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#comment_on_event_enabled ServiceJira#comment_on_event_enabled}
    */
    readonly commentOnEventEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for commit events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#commit_events ServiceJira#commit_events}
    */
    readonly commitEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for issues events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#issues_events ServiceJira#issues_events}
    */
    readonly issuesEvents?: boolean | cdktf.IResolvable;
    /**
    * The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#jira_issue_transition_id ServiceJira#jira_issue_transition_id}
    */
    readonly jiraIssueTransitionId?: string;
    /**
    * Enable notifications for job events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#job_events ServiceJira#job_events}
    */
    readonly jobEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for merge request events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#merge_requests_events ServiceJira#merge_requests_events}
    */
    readonly mergeRequestsEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for note events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#note_events ServiceJira#note_events}
    */
    readonly noteEvents?: boolean | cdktf.IResolvable;
    /**
    * The password of the user created to be used with GitLab/JIRA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#password ServiceJira#password}
    */
    readonly password: string;
    /**
    * Enable notifications for pipeline events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#pipeline_events ServiceJira#pipeline_events}
    */
    readonly pipelineEvents?: boolean | cdktf.IResolvable;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#project ServiceJira#project}
    */
    readonly project: string;
    /**
    * The short identifier for your JIRA project, all uppercase, e.g., PROJ.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#project_key ServiceJira#project_key}
    */
    readonly projectKey?: string;
    /**
    * Enable notifications for push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#push_events ServiceJira#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for tag_push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#tag_push_events ServiceJira#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
    /**
    * The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#url ServiceJira#url}
    */
    readonly url: string;
    /**
    * The username of the user created to be used with GitLab/JIRA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira#username ServiceJira#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira gitlab_service_jira}
*/
export declare class ServiceJira extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_jira";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_jira gitlab_service_jira} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceJiraConfig
    */
    constructor(scope: Construct, id: string, config: ServiceJiraConfig);
    get active(): cdktf.IResolvable;
    private _apiUrl?;
    get apiUrl(): string;
    set apiUrl(value: string);
    resetApiUrl(): void;
    get apiUrlInput(): string | undefined;
    private _commentOnEventEnabled?;
    get commentOnEventEnabled(): boolean | cdktf.IResolvable;
    set commentOnEventEnabled(value: boolean | cdktf.IResolvable);
    resetCommentOnEventEnabled(): void;
    get commentOnEventEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _commitEvents?;
    get commitEvents(): boolean | cdktf.IResolvable;
    set commitEvents(value: boolean | cdktf.IResolvable);
    resetCommitEvents(): void;
    get commitEventsInput(): boolean | cdktf.IResolvable | undefined;
    get createdAt(): string;
    get id(): string;
    private _issuesEvents?;
    get issuesEvents(): boolean | cdktf.IResolvable;
    set issuesEvents(value: boolean | cdktf.IResolvable);
    resetIssuesEvents(): void;
    get issuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _jiraIssueTransitionId?;
    get jiraIssueTransitionId(): string;
    set jiraIssueTransitionId(value: string);
    resetJiraIssueTransitionId(): void;
    get jiraIssueTransitionIdInput(): string | undefined;
    private _jobEvents?;
    get jobEvents(): boolean | cdktf.IResolvable;
    set jobEvents(value: boolean | cdktf.IResolvable);
    resetJobEvents(): void;
    get jobEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsEvents?;
    get mergeRequestsEvents(): boolean | cdktf.IResolvable;
    set mergeRequestsEvents(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEvents(): void;
    get mergeRequestsEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _noteEvents?;
    get noteEvents(): boolean | cdktf.IResolvable;
    set noteEvents(value: boolean | cdktf.IResolvable);
    resetNoteEvents(): void;
    get noteEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pipelineEvents?;
    get pipelineEvents(): boolean | cdktf.IResolvable;
    set pipelineEvents(value: boolean | cdktf.IResolvable);
    resetPipelineEvents(): void;
    get pipelineEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    resetProjectKey(): void;
    get projectKeyInput(): string | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    get title(): string;
    get updatedAt(): string;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
