"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectLevelMrApprovals = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals}
*/
class ProjectLevelMrApprovals extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectLevelMrApprovalsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project_level_mr_approvals',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._disableOverridingApproversPerMergeRequest = config.disableOverridingApproversPerMergeRequest;
        this._mergeRequestsAuthorApproval = config.mergeRequestsAuthorApproval;
        this._mergeRequestsDisableCommittersApproval = config.mergeRequestsDisableCommittersApproval;
        this._projectId = config.projectId;
        this._requirePasswordToApprove = config.requirePasswordToApprove;
        this._resetApprovalsOnPush = config.resetApprovalsOnPush;
    }
    get disableOverridingApproversPerMergeRequest() {
        return this.getBooleanAttribute('disable_overriding_approvers_per_merge_request');
    }
    set disableOverridingApproversPerMergeRequest(value) {
        this._disableOverridingApproversPerMergeRequest = value;
    }
    resetDisableOverridingApproversPerMergeRequest() {
        this._disableOverridingApproversPerMergeRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableOverridingApproversPerMergeRequestInput() {
        return this._disableOverridingApproversPerMergeRequest;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get mergeRequestsAuthorApproval() {
        return this.getBooleanAttribute('merge_requests_author_approval');
    }
    set mergeRequestsAuthorApproval(value) {
        this._mergeRequestsAuthorApproval = value;
    }
    resetMergeRequestsAuthorApproval() {
        this._mergeRequestsAuthorApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAuthorApprovalInput() {
        return this._mergeRequestsAuthorApproval;
    }
    get mergeRequestsDisableCommittersApproval() {
        return this.getBooleanAttribute('merge_requests_disable_committers_approval');
    }
    set mergeRequestsDisableCommittersApproval(value) {
        this._mergeRequestsDisableCommittersApproval = value;
    }
    resetMergeRequestsDisableCommittersApproval() {
        this._mergeRequestsDisableCommittersApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsDisableCommittersApprovalInput() {
        return this._mergeRequestsDisableCommittersApproval;
    }
    get projectId() {
        return this.getNumberAttribute('project_id');
    }
    set projectId(value) {
        this._projectId = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectIdInput() {
        return this._projectId;
    }
    get requirePasswordToApprove() {
        return this.getBooleanAttribute('require_password_to_approve');
    }
    set requirePasswordToApprove(value) {
        this._requirePasswordToApprove = value;
    }
    resetRequirePasswordToApprove() {
        this._requirePasswordToApprove = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirePasswordToApproveInput() {
        return this._requirePasswordToApprove;
    }
    get resetApprovalsOnPush() {
        return this.getBooleanAttribute('reset_approvals_on_push');
    }
    set resetApprovalsOnPush(value) {
        this._resetApprovalsOnPush = value;
    }
    resetResetApprovalsOnPush() {
        this._resetApprovalsOnPush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resetApprovalsOnPushInput() {
        return this._resetApprovalsOnPush;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            disable_overriding_approvers_per_merge_request: cdktf.booleanToTerraform(this._disableOverridingApproversPerMergeRequest),
            merge_requests_author_approval: cdktf.booleanToTerraform(this._mergeRequestsAuthorApproval),
            merge_requests_disable_committers_approval: cdktf.booleanToTerraform(this._mergeRequestsDisableCommittersApproval),
            project_id: cdktf.numberToTerraform(this._projectId),
            require_password_to_approve: cdktf.booleanToTerraform(this._requirePasswordToApprove),
            reset_approvals_on_push: cdktf.booleanToTerraform(this._resetApprovalsOnPush),
        };
    }
}
exports.ProjectLevelMrApprovals = ProjectLevelMrApprovals;
_a = JSII_RTTI_SYMBOL_1;
ProjectLevelMrApprovals[_a] = { fqn: "@cdktf/provider-gitlab.ProjectLevelMrApprovals", version: "0.0.2" };
// =================
// STATIC PROPERTIES
// =================
ProjectLevelMrApprovals.tfResourceType = "gitlab_project_level_mr_approvals";
//# sourceMappingURL=data:application/json;base64,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