import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Filter users that are active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#active DataGitlabUsers#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Filter users that are blocked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#blocked DataGitlabUsers#blocked}
    */
    readonly blocked?: boolean | cdktf.IResolvable;
    /**
    * Search for users created after a specific date. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#created_after DataGitlabUsers#created_after}
    */
    readonly createdAfter?: string;
    /**
    * Search for users created before a specific date. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#created_before DataGitlabUsers#created_before}
    */
    readonly createdBefore?: string;
    /**
    * Lookup users by external provider. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#extern_provider DataGitlabUsers#extern_provider}
    */
    readonly externProvider?: string;
    /**
    * Lookup users by external UID. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#extern_uid DataGitlabUsers#extern_uid}
    */
    readonly externUid?: string;
    /**
    * Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#order_by DataGitlabUsers#order_by}
    */
    readonly orderBy?: string;
    /**
    * Search users by username, name or email.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#search DataGitlabUsers#search}
    */
    readonly search?: string;
    /**
    * Sort users' list in asc or desc order. (Requires administrator privileges)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/users#sort DataGitlabUsers#sort}
    */
    readonly sort?: string;
}
export interface DataGitlabUsersUsers {
}
export declare function dataGitlabUsersUsersToTerraform(struct?: DataGitlabUsersUsers): any;
export declare class DataGitlabUsersUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabUsersUsers | undefined;
    set internalValue(value: DataGitlabUsersUsers | undefined);
    get avatarUrl(): string;
    get bio(): string;
    get canCreateGroup(): cdktf.IResolvable;
    get canCreateProject(): cdktf.IResolvable;
    get colorSchemeId(): number;
    get createdAt(): string;
    get currentSignInAt(): string;
    get email(): string;
    get externUid(): string;
    get external(): cdktf.IResolvable;
    get id(): number;
    get isAdmin(): cdktf.IResolvable;
    get lastSignInAt(): string;
    get linkedin(): string;
    get location(): string;
    get name(): string;
    get namespaceId(): number;
    get organization(): string;
    get projectsLimit(): number;
    get provider(): string;
    get skype(): string;
    get state(): string;
    get themeId(): number;
    get twitter(): string;
    get twoFactorEnabled(): cdktf.IResolvable;
    get username(): string;
    get websiteUrl(): string;
}
export declare class DataGitlabUsersUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabUsersUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/users gitlab_users}
*/
export declare class DataGitlabUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_users";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/users gitlab_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabUsersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabUsersConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _blocked?;
    get blocked(): boolean | cdktf.IResolvable;
    set blocked(value: boolean | cdktf.IResolvable);
    resetBlocked(): void;
    get blockedInput(): boolean | cdktf.IResolvable | undefined;
    private _createdAfter?;
    get createdAfter(): string;
    set createdAfter(value: string);
    resetCreatedAfter(): void;
    get createdAfterInput(): string | undefined;
    private _createdBefore?;
    get createdBefore(): string;
    set createdBefore(value: string);
    resetCreatedBefore(): void;
    get createdBeforeInput(): string | undefined;
    private _externProvider?;
    get externProvider(): string;
    set externProvider(value: string);
    resetExternProvider(): void;
    get externProviderInput(): string | undefined;
    private _externUid?;
    get externUid(): string;
    set externUid(value: string);
    resetExternUid(): void;
    get externUidInput(): string | undefined;
    get id(): string;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _users;
    get users(): DataGitlabUsersUsersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
