import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabInstanceDeployKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only return deploy keys that are public.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/instance_deploy_keys#public DataGitlabInstanceDeployKeys#public}
    */
    readonly public?: boolean | cdktf.IResolvable;
}
export interface DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccess {
}
export declare function dataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccessToTerraform(struct?: DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccess): any;
export declare class DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccess | undefined;
    set internalValue(value: DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccess | undefined);
    get createdAt(): string;
    get description(): string;
    get id(): number;
    get name(): string;
    get nameWithNamespace(): string;
    get path(): string;
    get pathWithNamespace(): string;
}
export declare class DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccessOutputReference;
}
export interface DataGitlabInstanceDeployKeysDeployKeys {
}
export declare function dataGitlabInstanceDeployKeysDeployKeysToTerraform(struct?: DataGitlabInstanceDeployKeysDeployKeys): any;
export declare class DataGitlabInstanceDeployKeysDeployKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabInstanceDeployKeysDeployKeys | undefined;
    set internalValue(value: DataGitlabInstanceDeployKeysDeployKeys | undefined);
    get createdAt(): string;
    get fingerprint(): string;
    get id(): number;
    get key(): string;
    private _projectsWithWriteAccess;
    get projectsWithWriteAccess(): DataGitlabInstanceDeployKeysDeployKeysProjectsWithWriteAccessList;
    get title(): string;
}
export declare class DataGitlabInstanceDeployKeysDeployKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabInstanceDeployKeysDeployKeysOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_deploy_keys gitlab_instance_deploy_keys}
*/
export declare class DataGitlabInstanceDeployKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_instance_deploy_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/instance_deploy_keys gitlab_instance_deploy_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabInstanceDeployKeysConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabInstanceDeployKeysConfig);
    private _deployKeys;
    get deployKeys(): DataGitlabInstanceDeployKeysDeployKeysList;
    get id(): string;
    private _public?;
    get public(): boolean | cdktf.IResolvable;
    set public(value: boolean | cdktf.IResolvable);
    resetPublic(): void;
    get publicInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
