import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupVariablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment scope of the variable. Defaults to all environment (`*`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_variables#environment_scope DataGitlabGroupVariables#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * The name or id of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_variables#group DataGitlabGroupVariables#group}
    */
    readonly group: string;
}
export interface DataGitlabGroupVariablesVariables {
}
export declare function dataGitlabGroupVariablesVariablesToTerraform(struct?: DataGitlabGroupVariablesVariables): any;
export declare class DataGitlabGroupVariablesVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabGroupVariablesVariables | undefined;
    set internalValue(value: DataGitlabGroupVariablesVariables | undefined);
    get environmentScope(): string;
    get group(): string;
    get key(): string;
    get masked(): cdktf.IResolvable;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
}
export declare class DataGitlabGroupVariablesVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabGroupVariablesVariablesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_variables gitlab_group_variables}
*/
export declare class DataGitlabGroupVariables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_variables";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_variables gitlab_group_variables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupVariablesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabGroupVariablesConfig);
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _variables;
    get variables(): DataGitlabGroupVariablesVariablesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
