import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable#environment_scope DataGitlabGroupVariable#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * The name or id of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable#group DataGitlabGroupVariable#group}
    */
    readonly group: string;
    /**
    * The name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable#key DataGitlabGroupVariable#key}
    */
    readonly key: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable gitlab_group_variable}
*/
export declare class DataGitlabGroupVariable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable gitlab_group_variable} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupVariableConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabGroupVariableConfig);
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get masked(): cdktf.IResolvable;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
