# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DomainEntityRef
    from . import WorkdayValuesTrendItem

class WorkdayValuesMetricItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WorkdayValuesMetricItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'metric': 'AddressableEntityRef',
            'metric_definition': 'DomainEntityRef',
            'average': 'float',
            'unit_type': 'str',
            'trend': 'list[WorkdayValuesTrendItem]'
        }

        self.attribute_map = {
            'metric': 'metric',
            'metric_definition': 'metricDefinition',
            'average': 'average',
            'unit_type': 'unitType',
            'trend': 'trend'
        }

        self._metric = None
        self._metric_definition = None
        self._average = None
        self._unit_type = None
        self._trend = None

    @property
    def metric(self) -> 'AddressableEntityRef':
        """
        Gets the metric of this WorkdayValuesMetricItem.
        Gamification metric for the average and the trend

        :return: The metric of this WorkdayValuesMetricItem.
        :rtype: AddressableEntityRef
        """
        return self._metric

    @metric.setter
    def metric(self, metric: 'AddressableEntityRef') -> None:
        """
        Sets the metric of this WorkdayValuesMetricItem.
        Gamification metric for the average and the trend

        :param metric: The metric of this WorkdayValuesMetricItem.
        :type: AddressableEntityRef
        """
        

        self._metric = metric

    @property
    def metric_definition(self) -> 'DomainEntityRef':
        """
        Gets the metric_definition of this WorkdayValuesMetricItem.
        Gamification metric definition for the average and the trend

        :return: The metric_definition of this WorkdayValuesMetricItem.
        :rtype: DomainEntityRef
        """
        return self._metric_definition

    @metric_definition.setter
    def metric_definition(self, metric_definition: 'DomainEntityRef') -> None:
        """
        Sets the metric_definition of this WorkdayValuesMetricItem.
        Gamification metric definition for the average and the trend

        :param metric_definition: The metric_definition of this WorkdayValuesMetricItem.
        :type: DomainEntityRef
        """
        

        self._metric_definition = metric_definition

    @property
    def average(self) -> float:
        """
        Gets the average of this WorkdayValuesMetricItem.
        The average value of the metric

        :return: The average of this WorkdayValuesMetricItem.
        :rtype: float
        """
        return self._average

    @average.setter
    def average(self, average: float) -> None:
        """
        Sets the average of this WorkdayValuesMetricItem.
        The average value of the metric

        :param average: The average of this WorkdayValuesMetricItem.
        :type: float
        """
        

        self._average = average

    @property
    def unit_type(self) -> str:
        """
        Gets the unit_type of this WorkdayValuesMetricItem.
        The unit type of the metric value

        :return: The unit_type of this WorkdayValuesMetricItem.
        :rtype: str
        """
        return self._unit_type

    @unit_type.setter
    def unit_type(self, unit_type: str) -> None:
        """
        Sets the unit_type of this WorkdayValuesMetricItem.
        The unit type of the metric value

        :param unit_type: The unit_type of this WorkdayValuesMetricItem.
        :type: str
        """
        if isinstance(unit_type, int):
            unit_type = str(unit_type)
        allowed_values = ["None", "Percent", "Currency", "Seconds", "Number", "AttendanceStatus", "Unit"]
        if unit_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_type -> " + unit_type)
            self._unit_type = "outdated_sdk_version"
        else:
            self._unit_type = unit_type

    @property
    def trend(self) -> List['WorkdayValuesTrendItem']:
        """
        Gets the trend of this WorkdayValuesMetricItem.
        The metric value trend

        :return: The trend of this WorkdayValuesMetricItem.
        :rtype: list[WorkdayValuesTrendItem]
        """
        return self._trend

    @trend.setter
    def trend(self, trend: List['WorkdayValuesTrendItem']) -> None:
        """
        Sets the trend of this WorkdayValuesMetricItem.
        The metric value trend

        :param trend: The trend of this WorkdayValuesMetricItem.
        :type: list[WorkdayValuesTrendItem]
        """
        

        self._trend = trend

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

