# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class V2ConversationMessageTypingEventForUserTopicConversationContentLocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForUserTopicConversationContentLocation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'url': 'str',
            'address': 'str',
            'text': 'str',
            'latitude': 'float',
            'longitude': 'float'
        }

        self.attribute_map = {
            'url': 'url',
            'address': 'address',
            'text': 'text',
            'latitude': 'latitude',
            'longitude': 'longitude'
        }

        self._url = None
        self._address = None
        self._text = None
        self._latitude = None
        self._longitude = None

    @property
    def url(self) -> str:
        """
        Gets the url of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :return: The url of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :param url: The url of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :type: str
        """
        

        self._url = url

    @property
    def address(self) -> str:
        """
        Gets the address of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :return: The address of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :param address: The address of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :type: str
        """
        

        self._address = address

    @property
    def text(self) -> str:
        """
        Gets the text of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :return: The text of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :param text: The text of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :type: str
        """
        

        self._text = text

    @property
    def latitude(self) -> float:
        """
        Gets the latitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :return: The latitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :rtype: float
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude: float) -> None:
        """
        Sets the latitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :param latitude: The latitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :type: float
        """
        

        self._latitude = latitude

    @property
    def longitude(self) -> float:
        """
        Gets the longitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :return: The longitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :rtype: float
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude: float) -> None:
        """
        Sets the longitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.


        :param longitude: The longitude of this V2ConversationMessageTypingEventForUserTopicConversationContentLocation.
        :type: float
        """
        

        self._longitude = longitude

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

