# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class UserPresenceEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserPresenceEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_id': 'str',
            'event_date_time': 'datetime',
            'user_id': 'str',
            'source_id': 'str',
            'presence_definition_id': 'str',
            'message': 'str'
        }

        self.attribute_map = {
            'event_id': 'eventId',
            'event_date_time': 'eventDateTime',
            'user_id': 'userId',
            'source_id': 'sourceId',
            'presence_definition_id': 'presenceDefinitionId',
            'message': 'message'
        }

        self._event_id = None
        self._event_date_time = None
        self._user_id = None
        self._source_id = None
        self._presence_definition_id = None
        self._message = None

    @property
    def event_id(self) -> str:
        """
        Gets the event_id of this UserPresenceEvent.
        A unique (V4 UUID) eventId for this event

        :return: The event_id of this UserPresenceEvent.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id: str) -> None:
        """
        Sets the event_id of this UserPresenceEvent.
        A unique (V4 UUID) eventId for this event

        :param event_id: The event_id of this UserPresenceEvent.
        :type: str
        """
        

        self._event_id = event_id

    @property
    def event_date_time(self) -> datetime:
        """
        Gets the event_date_time of this UserPresenceEvent.
        A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The event_date_time of this UserPresenceEvent.
        :rtype: datetime
        """
        return self._event_date_time

    @event_date_time.setter
    def event_date_time(self, event_date_time: datetime) -> None:
        """
        Sets the event_date_time of this UserPresenceEvent.
        A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param event_date_time: The event_date_time of this UserPresenceEvent.
        :type: datetime
        """
        

        self._event_date_time = event_date_time

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this UserPresenceEvent.
        The User ID of the user associated with this UserPresence

        :return: The user_id of this UserPresenceEvent.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this UserPresenceEvent.
        The User ID of the user associated with this UserPresence

        :param user_id: The user_id of this UserPresenceEvent.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this UserPresenceEvent.
        The id (V4 UUID) of the presence source being updated

        :return: The source_id of this UserPresenceEvent.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this UserPresenceEvent.
        The id (V4 UUID) of the presence source being updated

        :param source_id: The source_id of this UserPresenceEvent.
        :type: str
        """
        

        self._source_id = source_id

    @property
    def presence_definition_id(self) -> str:
        """
        Gets the presence_definition_id of this UserPresenceEvent.
        The id (UUID) of the presence definition that the user presence is associated with

        :return: The presence_definition_id of this UserPresenceEvent.
        :rtype: str
        """
        return self._presence_definition_id

    @presence_definition_id.setter
    def presence_definition_id(self, presence_definition_id: str) -> None:
        """
        Sets the presence_definition_id of this UserPresenceEvent.
        The id (UUID) of the presence definition that the user presence is associated with

        :param presence_definition_id: The presence_definition_id of this UserPresenceEvent.
        :type: str
        """
        

        self._presence_definition_id = presence_definition_id

    @property
    def message(self) -> str:
        """
        Gets the message of this UserPresenceEvent.
        The message associated with the presence

        :return: The message of this UserPresenceEvent.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this UserPresenceEvent.
        The message associated with the presence

        :param message: The message of this UserPresenceEvent.
        :type: str
        """
        

        self._message = message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

