# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TextBotUserAgent

class TextBotChannel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TextBotChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'input_modes': 'list[str]',
            'output_modes': 'list[str]',
            'user_agent': 'TextBotUserAgent'
        }

        self.attribute_map = {
            'name': 'name',
            'input_modes': 'inputModes',
            'output_modes': 'outputModes',
            'user_agent': 'userAgent'
        }

        self._name = None
        self._input_modes = None
        self._output_modes = None
        self._user_agent = None

    @property
    def name(self) -> str:
        """
        Gets the name of this TextBotChannel.
        The name of the channel.

        :return: The name of this TextBotChannel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this TextBotChannel.
        The name of the channel.

        :param name: The name of this TextBotChannel.
        :type: str
        """
        if isinstance(name, int):
            name = str(name)
        allowed_values = ["Chat", "Call", "Messaging"]
        if name.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for name -> " + name)
            self._name = "outdated_sdk_version"
        else:
            self._name = name

    @property
    def input_modes(self) -> List[str]:
        """
        Gets the input_modes of this TextBotChannel.
        The input modes for the channel.

        :return: The input_modes of this TextBotChannel.
        :rtype: list[str]
        """
        return self._input_modes

    @input_modes.setter
    def input_modes(self, input_modes: List[str]) -> None:
        """
        Sets the input_modes of this TextBotChannel.
        The input modes for the channel.

        :param input_modes: The input_modes of this TextBotChannel.
        :type: list[str]
        """
        

        self._input_modes = input_modes

    @property
    def output_modes(self) -> List[str]:
        """
        Gets the output_modes of this TextBotChannel.
        The output modes for the channel.

        :return: The output_modes of this TextBotChannel.
        :rtype: list[str]
        """
        return self._output_modes

    @output_modes.setter
    def output_modes(self, output_modes: List[str]) -> None:
        """
        Sets the output_modes of this TextBotChannel.
        The output modes for the channel.

        :param output_modes: The output_modes of this TextBotChannel.
        :type: list[str]
        """
        

        self._output_modes = output_modes

    @property
    def user_agent(self) -> 'TextBotUserAgent':
        """
        Gets the user_agent of this TextBotChannel.
        Information about the end user agent calling the bot flow.

        :return: The user_agent of this TextBotChannel.
        :rtype: TextBotUserAgent
        """
        return self._user_agent

    @user_agent.setter
    def user_agent(self, user_agent: 'TextBotUserAgent') -> None:
        """
        Sets the user_agent of this TextBotChannel.
        Information about the end user agent calling the bot flow.

        :param user_agent: The user_agent of this TextBotChannel.
        :type: TextBotUserAgent
        """
        

        self._user_agent = user_agent

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

