# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class SupportCenterGlobalStyle(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SupportCenterGlobalStyle - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'background_color': 'str',
            'primary_color': 'str',
            'primary_color_dark': 'str',
            'primary_color_light': 'str',
            'text_color': 'str',
            'font_family': 'str'
        }

        self.attribute_map = {
            'background_color': 'backgroundColor',
            'primary_color': 'primaryColor',
            'primary_color_dark': 'primaryColorDark',
            'primary_color_light': 'primaryColorLight',
            'text_color': 'textColor',
            'font_family': 'fontFamily'
        }

        self._background_color = None
        self._primary_color = None
        self._primary_color_dark = None
        self._primary_color_light = None
        self._text_color = None
        self._font_family = None

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this SupportCenterGlobalStyle.
        Global background color, in hexadecimal format, eg #ffffff

        :return: The background_color of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this SupportCenterGlobalStyle.
        Global background color, in hexadecimal format, eg #ffffff

        :param background_color: The background_color of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._background_color = background_color

    @property
    def primary_color(self) -> str:
        """
        Gets the primary_color of this SupportCenterGlobalStyle.
        Global primary color, in hexadecimal format, eg #ffffff

        :return: The primary_color of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._primary_color

    @primary_color.setter
    def primary_color(self, primary_color: str) -> None:
        """
        Sets the primary_color of this SupportCenterGlobalStyle.
        Global primary color, in hexadecimal format, eg #ffffff

        :param primary_color: The primary_color of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._primary_color = primary_color

    @property
    def primary_color_dark(self) -> str:
        """
        Gets the primary_color_dark of this SupportCenterGlobalStyle.
        Global dark primary color, in hexadecimal format, eg #ffffff

        :return: The primary_color_dark of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._primary_color_dark

    @primary_color_dark.setter
    def primary_color_dark(self, primary_color_dark: str) -> None:
        """
        Sets the primary_color_dark of this SupportCenterGlobalStyle.
        Global dark primary color, in hexadecimal format, eg #ffffff

        :param primary_color_dark: The primary_color_dark of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._primary_color_dark = primary_color_dark

    @property
    def primary_color_light(self) -> str:
        """
        Gets the primary_color_light of this SupportCenterGlobalStyle.
        Global light primary color, in hexadecimal format, eg #ffffff

        :return: The primary_color_light of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._primary_color_light

    @primary_color_light.setter
    def primary_color_light(self, primary_color_light: str) -> None:
        """
        Sets the primary_color_light of this SupportCenterGlobalStyle.
        Global light primary color, in hexadecimal format, eg #ffffff

        :param primary_color_light: The primary_color_light of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._primary_color_light = primary_color_light

    @property
    def text_color(self) -> str:
        """
        Gets the text_color of this SupportCenterGlobalStyle.
        Global text color, in hexadecimal format, eg #ffffff

        :return: The text_color of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._text_color

    @text_color.setter
    def text_color(self, text_color: str) -> None:
        """
        Sets the text_color of this SupportCenterGlobalStyle.
        Global text color, in hexadecimal format, eg #ffffff

        :param text_color: The text_color of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._text_color = text_color

    @property
    def font_family(self) -> str:
        """
        Gets the font_family of this SupportCenterGlobalStyle.
        Global font family

        :return: The font_family of this SupportCenterGlobalStyle.
        :rtype: str
        """
        return self._font_family

    @font_family.setter
    def font_family(self, font_family: str) -> None:
        """
        Sets the font_family of this SupportCenterGlobalStyle.
        Global font family

        :param font_family: The font_family of this SupportCenterGlobalStyle.
        :type: str
        """
        

        self._font_family = font_family

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

