# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Actions
    from . import ExpansionCriterium
    from . import MemberGroup

class Ring(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Ring - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'expansion_criteria': 'list[ExpansionCriterium]',
            'actions': 'Actions',
            'member_groups': 'list[MemberGroup]'
        }

        self.attribute_map = {
            'expansion_criteria': 'expansionCriteria',
            'actions': 'actions',
            'member_groups': 'memberGroups'
        }

        self._expansion_criteria = None
        self._actions = None
        self._member_groups = None

    @property
    def expansion_criteria(self) -> List['ExpansionCriterium']:
        """
        Gets the expansion_criteria of this Ring.
        The conditions that will trigger conversations to move to the next bullseye ring.

        :return: The expansion_criteria of this Ring.
        :rtype: list[ExpansionCriterium]
        """
        return self._expansion_criteria

    @expansion_criteria.setter
    def expansion_criteria(self, expansion_criteria: List['ExpansionCriterium']) -> None:
        """
        Sets the expansion_criteria of this Ring.
        The conditions that will trigger conversations to move to the next bullseye ring.

        :param expansion_criteria: The expansion_criteria of this Ring.
        :type: list[ExpansionCriterium]
        """
        

        self._expansion_criteria = expansion_criteria

    @property
    def actions(self) -> 'Actions':
        """
        Gets the actions of this Ring.
        The actions that will be performed just before moving conversations to the next bullseye ring.

        :return: The actions of this Ring.
        :rtype: Actions
        """
        return self._actions

    @actions.setter
    def actions(self, actions: 'Actions') -> None:
        """
        Sets the actions of this Ring.
        The actions that will be performed just before moving conversations to the next bullseye ring.

        :param actions: The actions of this Ring.
        :type: Actions
        """
        

        self._actions = actions

    @property
    def member_groups(self) -> List['MemberGroup']:
        """
        Gets the member_groups of this Ring.
        The groups of agents associated with the ring, if any.  Ring membership will update to match group membership changes.

        :return: The member_groups of this Ring.
        :rtype: list[MemberGroup]
        """
        return self._member_groups

    @member_groups.setter
    def member_groups(self, member_groups: List['MemberGroup']) -> None:
        """
        Sets the member_groups of this Ring.
        The groups of agents associated with the ring, if any.  Ring membership will update to match group membership changes.

        :param member_groups: The member_groups of this Ring.
        :type: list[MemberGroup]
        """
        

        self._member_groups = member_groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

