# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ReportingTurnKnowledgeFeedback
    from . import ReportingTurnKnowledgeSearch

class ReportingTurnKnowledge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ReportingTurnKnowledge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'knowledge_base_id': 'str',
            'feedback': 'ReportingTurnKnowledgeFeedback',
            'search': 'ReportingTurnKnowledgeSearch'
        }

        self.attribute_map = {
            'knowledge_base_id': 'knowledgeBaseId',
            'feedback': 'feedback',
            'search': 'search'
        }

        self._knowledge_base_id = None
        self._feedback = None
        self._search = None

    @property
    def knowledge_base_id(self) -> str:
        """
        Gets the knowledge_base_id of this ReportingTurnKnowledge.
        The Knowledge Base ID that the captured knowledge data relates to.

        :return: The knowledge_base_id of this ReportingTurnKnowledge.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id: str) -> None:
        """
        Sets the knowledge_base_id of this ReportingTurnKnowledge.
        The Knowledge Base ID that the captured knowledge data relates to.

        :param knowledge_base_id: The knowledge_base_id of this ReportingTurnKnowledge.
        :type: str
        """
        

        self._knowledge_base_id = knowledge_base_id

    @property
    def feedback(self) -> 'ReportingTurnKnowledgeFeedback':
        """
        Gets the feedback of this ReportingTurnKnowledge.
        The knowledge feedback data that was captured during this reporting turn.

        :return: The feedback of this ReportingTurnKnowledge.
        :rtype: ReportingTurnKnowledgeFeedback
        """
        return self._feedback

    @feedback.setter
    def feedback(self, feedback: 'ReportingTurnKnowledgeFeedback') -> None:
        """
        Sets the feedback of this ReportingTurnKnowledge.
        The knowledge feedback data that was captured during this reporting turn.

        :param feedback: The feedback of this ReportingTurnKnowledge.
        :type: ReportingTurnKnowledgeFeedback
        """
        

        self._feedback = feedback

    @property
    def search(self) -> 'ReportingTurnKnowledgeSearch':
        """
        Gets the search of this ReportingTurnKnowledge.
        The knowledge search data that was captured during this reporting turn.

        :return: The search of this ReportingTurnKnowledge.
        :rtype: ReportingTurnKnowledgeSearch
        """
        return self._search

    @search.setter
    def search(self, search: 'ReportingTurnKnowledgeSearch') -> None:
        """
        Sets the search of this ReportingTurnKnowledge.
        The knowledge search data that was captured during this reporting turn.

        :param search: The search of this ReportingTurnKnowledge.
        :type: ReportingTurnKnowledgeSearch
        """
        

        self._search = search

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

