# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ErrorBody

class RecordingEncryptionConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RecordingEncryptionConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'url': 'str',
            'api_id': 'str',
            'api_key': 'str',
            'key_configuration_type': 'str',
            'last_error': 'ErrorBody',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'url': 'url',
            'api_id': 'apiId',
            'api_key': 'apiKey',
            'key_configuration_type': 'keyConfigurationType',
            'last_error': 'lastError',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._url = None
        self._api_id = None
        self._api_key = None
        self._key_configuration_type = None
        self._last_error = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this RecordingEncryptionConfiguration.
        The globally unique identifier for the object.

        :return: The id of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this RecordingEncryptionConfiguration.
        The globally unique identifier for the object.

        :param id: The id of this RecordingEncryptionConfiguration.
        :type: str
        """
        

        self._id = id

    @property
    def url(self) -> str:
        """
        Gets the url of this RecordingEncryptionConfiguration.
        When keyConfigurationType is LocalKeyManager, this should be the url for decryption and must specify the path to where GenesysCloud can requests decryption. When keyConfigurationType is KmsSymmetric, this should be the arn to the key alias for the master key

        :return: The url of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this RecordingEncryptionConfiguration.
        When keyConfigurationType is LocalKeyManager, this should be the url for decryption and must specify the path to where GenesysCloud can requests decryption. When keyConfigurationType is KmsSymmetric, this should be the arn to the key alias for the master key

        :param url: The url of this RecordingEncryptionConfiguration.
        :type: str
        """
        

        self._url = url

    @property
    def api_id(self) -> str:
        """
        Gets the api_id of this RecordingEncryptionConfiguration.
        The api id for Hawk Authentication. Null if keyConfigurationType is KmsSymmetric

        :return: The api_id of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._api_id

    @api_id.setter
    def api_id(self, api_id: str) -> None:
        """
        Sets the api_id of this RecordingEncryptionConfiguration.
        The api id for Hawk Authentication. Null if keyConfigurationType is KmsSymmetric

        :param api_id: The api_id of this RecordingEncryptionConfiguration.
        :type: str
        """
        

        self._api_id = api_id

    @property
    def api_key(self) -> str:
        """
        Gets the api_key of this RecordingEncryptionConfiguration.
        The api shared symmetric key used for hawk authentication. Null if keyConfigurationType is KmsSymmetric

        :return: The api_key of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._api_key

    @api_key.setter
    def api_key(self, api_key: str) -> None:
        """
        Sets the api_key of this RecordingEncryptionConfiguration.
        The api shared symmetric key used for hawk authentication. Null if keyConfigurationType is KmsSymmetric

        :param api_key: The api_key of this RecordingEncryptionConfiguration.
        :type: str
        """
        

        self._api_key = api_key

    @property
    def key_configuration_type(self) -> str:
        """
        Gets the key_configuration_type of this RecordingEncryptionConfiguration.
        Type should be LocalKeyManager or KmsSymmetric when create or update Key configurations; 'Native' for disabling configuration.

        :return: The key_configuration_type of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._key_configuration_type

    @key_configuration_type.setter
    def key_configuration_type(self, key_configuration_type: str) -> None:
        """
        Sets the key_configuration_type of this RecordingEncryptionConfiguration.
        Type should be LocalKeyManager or KmsSymmetric when create or update Key configurations; 'Native' for disabling configuration.

        :param key_configuration_type: The key_configuration_type of this RecordingEncryptionConfiguration.
        :type: str
        """
        if isinstance(key_configuration_type, int):
            key_configuration_type = str(key_configuration_type)
        allowed_values = ["KmsSymmetric", "LocalKeyManager", "Native", "None"]
        if key_configuration_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for key_configuration_type -> " + key_configuration_type)
            self._key_configuration_type = "outdated_sdk_version"
        else:
            self._key_configuration_type = key_configuration_type

    @property
    def last_error(self) -> 'ErrorBody':
        """
        Gets the last_error of this RecordingEncryptionConfiguration.
        The error message related to the configuration

        :return: The last_error of this RecordingEncryptionConfiguration.
        :rtype: ErrorBody
        """
        return self._last_error

    @last_error.setter
    def last_error(self, last_error: 'ErrorBody') -> None:
        """
        Sets the last_error of this RecordingEncryptionConfiguration.
        The error message related to the configuration

        :param last_error: The last_error of this RecordingEncryptionConfiguration.
        :type: ErrorBody
        """
        

        self._last_error = last_error

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this RecordingEncryptionConfiguration.
        The URI for this object

        :return: The self_uri of this RecordingEncryptionConfiguration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this RecordingEncryptionConfiguration.
        The URI for this object

        :param self_uri: The self_uri of this RecordingEncryptionConfiguration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

