# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueConversationScreenShareEventTopicConversationRoutingData
    from . import QueueConversationScreenShareEventTopicErrorBody
    from . import QueueConversationScreenShareEventTopicJourneyContext
    from . import QueueConversationScreenShareEventTopicUriReference
    from . import QueueConversationScreenShareEventTopicWrapup

class QueueConversationScreenShareEventTopicScreenShareMediaParticipant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationScreenShareEventTopicScreenShareMediaParticipant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'address': 'str',
            'start_time': 'datetime',
            'connected_time': 'datetime',
            'end_time': 'datetime',
            'start_hold_time': 'datetime',
            'purpose': 'str',
            'state': 'str',
            'initial_state': 'str',
            'direction': 'str',
            'disconnect_type': 'str',
            'held': 'bool',
            'wrapup_required': 'bool',
            'wrapup_prompt': 'str',
            'user': 'QueueConversationScreenShareEventTopicUriReference',
            'queue': 'QueueConversationScreenShareEventTopicUriReference',
            'team': 'QueueConversationScreenShareEventTopicUriReference',
            'attributes': 'dict(str, str)',
            'error_info': 'QueueConversationScreenShareEventTopicErrorBody',
            'script': 'QueueConversationScreenShareEventTopicUriReference',
            'wrapup_timeout_ms': 'int',
            'wrapup_skipped': 'bool',
            'alerting_timeout_ms': 'int',
            'provider': 'str',
            'external_contact': 'QueueConversationScreenShareEventTopicUriReference',
            'external_organization': 'QueueConversationScreenShareEventTopicUriReference',
            'wrapup': 'QueueConversationScreenShareEventTopicWrapup',
            'conversation_routing_data': 'QueueConversationScreenShareEventTopicConversationRoutingData',
            'peer': 'str',
            'screen_recording_state': 'str',
            'flagged_reason': 'str',
            'journey_context': 'QueueConversationScreenShareEventTopicJourneyContext',
            'start_acw_time': 'datetime',
            'end_acw_time': 'datetime',
            'media_roles': 'list[str]',
            'context': 'str',
            'peer_count': 'int',
            'sharing': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'address': 'address',
            'start_time': 'startTime',
            'connected_time': 'connectedTime',
            'end_time': 'endTime',
            'start_hold_time': 'startHoldTime',
            'purpose': 'purpose',
            'state': 'state',
            'initial_state': 'initialState',
            'direction': 'direction',
            'disconnect_type': 'disconnectType',
            'held': 'held',
            'wrapup_required': 'wrapupRequired',
            'wrapup_prompt': 'wrapupPrompt',
            'user': 'user',
            'queue': 'queue',
            'team': 'team',
            'attributes': 'attributes',
            'error_info': 'errorInfo',
            'script': 'script',
            'wrapup_timeout_ms': 'wrapupTimeoutMs',
            'wrapup_skipped': 'wrapupSkipped',
            'alerting_timeout_ms': 'alertingTimeoutMs',
            'provider': 'provider',
            'external_contact': 'externalContact',
            'external_organization': 'externalOrganization',
            'wrapup': 'wrapup',
            'conversation_routing_data': 'conversationRoutingData',
            'peer': 'peer',
            'screen_recording_state': 'screenRecordingState',
            'flagged_reason': 'flaggedReason',
            'journey_context': 'journeyContext',
            'start_acw_time': 'startAcwTime',
            'end_acw_time': 'endAcwTime',
            'media_roles': 'mediaRoles',
            'context': 'context',
            'peer_count': 'peerCount',
            'sharing': 'sharing'
        }

        self._id = None
        self._name = None
        self._address = None
        self._start_time = None
        self._connected_time = None
        self._end_time = None
        self._start_hold_time = None
        self._purpose = None
        self._state = None
        self._initial_state = None
        self._direction = None
        self._disconnect_type = None
        self._held = None
        self._wrapup_required = None
        self._wrapup_prompt = None
        self._user = None
        self._queue = None
        self._team = None
        self._attributes = None
        self._error_info = None
        self._script = None
        self._wrapup_timeout_ms = None
        self._wrapup_skipped = None
        self._alerting_timeout_ms = None
        self._provider = None
        self._external_contact = None
        self._external_organization = None
        self._wrapup = None
        self._conversation_routing_data = None
        self._peer = None
        self._screen_recording_state = None
        self._flagged_reason = None
        self._journey_context = None
        self._start_acw_time = None
        self._end_acw_time = None
        self._media_roles = None
        self._context = None
        self._peer_count = None
        self._sharing = None

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The id of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param id: The id of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The name of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param name: The name of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._name = name

    @property
    def address(self) -> str:
        """
        Gets the address of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The address of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param address: The address of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._address = address

    @property
    def start_time(self) -> datetime:
        """
        Gets the start_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The start_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time: datetime) -> None:
        """
        Sets the start_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param start_time: The start_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._start_time = start_time

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The connected_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param connected_time: The connected_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def end_time(self) -> datetime:
        """
        Gets the end_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The end_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time: datetime) -> None:
        """
        Sets the end_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param end_time: The end_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._end_time = end_time

    @property
    def start_hold_time(self) -> datetime:
        """
        Gets the start_hold_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The start_hold_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._start_hold_time

    @start_hold_time.setter
    def start_hold_time(self, start_hold_time: datetime) -> None:
        """
        Sets the start_hold_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param start_hold_time: The start_hold_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._start_hold_time = start_hold_time

    @property
    def purpose(self) -> str:
        """
        Gets the purpose of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The purpose of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose: str) -> None:
        """
        Sets the purpose of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param purpose: The purpose of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._purpose = purpose

    @property
    def state(self) -> str:
        """
        Gets the state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param state: The state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initial_state(self) -> str:
        """
        Gets the initial_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The initial_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._initial_state

    @initial_state.setter
    def initial_state(self, initial_state: str) -> None:
        """
        Sets the initial_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param initial_state: The initial_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        if isinstance(initial_state, int):
            initial_state = str(initial_state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "scheduled", "none"]
        if initial_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for initial_state -> " + initial_state)
            self._initial_state = "outdated_sdk_version"
        else:
            self._initial_state = initial_state

    @property
    def direction(self) -> str:
        """
        Gets the direction of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The direction of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param direction: The direction of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The disconnect_type of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param disconnect_type: The disconnect_type of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["endpoint", "client", "system", "transfer", "timeout", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "uncallable"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def held(self) -> bool:
        """
        Gets the held of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The held of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param held: The held of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: bool
        """
        

        self._held = held

    @property
    def wrapup_required(self) -> bool:
        """
        Gets the wrapup_required of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The wrapup_required of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_required

    @wrapup_required.setter
    def wrapup_required(self, wrapup_required: bool) -> None:
        """
        Sets the wrapup_required of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param wrapup_required: The wrapup_required of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: bool
        """
        

        self._wrapup_required = wrapup_required

    @property
    def wrapup_prompt(self) -> str:
        """
        Gets the wrapup_prompt of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The wrapup_prompt of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._wrapup_prompt

    @wrapup_prompt.setter
    def wrapup_prompt(self, wrapup_prompt: str) -> None:
        """
        Sets the wrapup_prompt of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param wrapup_prompt: The wrapup_prompt of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._wrapup_prompt = wrapup_prompt

    @property
    def user(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the user of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The user of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._user

    @user.setter
    def user(self, user: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the user of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param user: The user of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._user = user

    @property
    def queue(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the queue of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The queue of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the queue of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param queue: The queue of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._queue = queue

    @property
    def team(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the team of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The team of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._team

    @team.setter
    def team(self, team: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the team of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param team: The team of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._team = team

    @property
    def attributes(self) -> Dict[str, str]:
        """
        Gets the attributes of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The attributes of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, str]) -> None:
        """
        Sets the attributes of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param attributes: The attributes of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def error_info(self) -> 'QueueConversationScreenShareEventTopicErrorBody':
        """
        Gets the error_info of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The error_info of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicErrorBody
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'QueueConversationScreenShareEventTopicErrorBody') -> None:
        """
        Sets the error_info of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param error_info: The error_info of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicErrorBody
        """
        

        self._error_info = error_info

    @property
    def script(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the script of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The script of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._script

    @script.setter
    def script(self, script: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the script of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param script: The script of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._script = script

    @property
    def wrapup_timeout_ms(self) -> int:
        """
        Gets the wrapup_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The wrapup_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: int
        """
        return self._wrapup_timeout_ms

    @wrapup_timeout_ms.setter
    def wrapup_timeout_ms(self, wrapup_timeout_ms: int) -> None:
        """
        Sets the wrapup_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param wrapup_timeout_ms: The wrapup_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: int
        """
        

        self._wrapup_timeout_ms = wrapup_timeout_ms

    @property
    def wrapup_skipped(self) -> bool:
        """
        Gets the wrapup_skipped of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The wrapup_skipped of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_skipped

    @wrapup_skipped.setter
    def wrapup_skipped(self, wrapup_skipped: bool) -> None:
        """
        Sets the wrapup_skipped of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param wrapup_skipped: The wrapup_skipped of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: bool
        """
        

        self._wrapup_skipped = wrapup_skipped

    @property
    def alerting_timeout_ms(self) -> int:
        """
        Gets the alerting_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The alerting_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: int
        """
        return self._alerting_timeout_ms

    @alerting_timeout_ms.setter
    def alerting_timeout_ms(self, alerting_timeout_ms: int) -> None:
        """
        Sets the alerting_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param alerting_timeout_ms: The alerting_timeout_ms of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: int
        """
        

        self._alerting_timeout_ms = alerting_timeout_ms

    @property
    def provider(self) -> str:
        """
        Gets the provider of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The provider of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param provider: The provider of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._provider = provider

    @property
    def external_contact(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the external_contact of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The external_contact of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the external_contact of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param external_contact: The external_contact of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._external_contact = external_contact

    @property
    def external_organization(self) -> 'QueueConversationScreenShareEventTopicUriReference':
        """
        Gets the external_organization of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The external_organization of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicUriReference
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'QueueConversationScreenShareEventTopicUriReference') -> None:
        """
        Sets the external_organization of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param external_organization: The external_organization of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicUriReference
        """
        

        self._external_organization = external_organization

    @property
    def wrapup(self) -> 'QueueConversationScreenShareEventTopicWrapup':
        """
        Gets the wrapup of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The wrapup of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicWrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'QueueConversationScreenShareEventTopicWrapup') -> None:
        """
        Sets the wrapup of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param wrapup: The wrapup of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicWrapup
        """
        

        self._wrapup = wrapup

    @property
    def conversation_routing_data(self) -> 'QueueConversationScreenShareEventTopicConversationRoutingData':
        """
        Gets the conversation_routing_data of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The conversation_routing_data of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicConversationRoutingData
        """
        return self._conversation_routing_data

    @conversation_routing_data.setter
    def conversation_routing_data(self, conversation_routing_data: 'QueueConversationScreenShareEventTopicConversationRoutingData') -> None:
        """
        Sets the conversation_routing_data of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param conversation_routing_data: The conversation_routing_data of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicConversationRoutingData
        """
        

        self._conversation_routing_data = conversation_routing_data

    @property
    def peer(self) -> str:
        """
        Gets the peer of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The peer of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._peer

    @peer.setter
    def peer(self, peer: str) -> None:
        """
        Sets the peer of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param peer: The peer of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._peer = peer

    @property
    def screen_recording_state(self) -> str:
        """
        Gets the screen_recording_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The screen_recording_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._screen_recording_state

    @screen_recording_state.setter
    def screen_recording_state(self, screen_recording_state: str) -> None:
        """
        Sets the screen_recording_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param screen_recording_state: The screen_recording_state of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._screen_recording_state = screen_recording_state

    @property
    def flagged_reason(self) -> str:
        """
        Gets the flagged_reason of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The flagged_reason of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._flagged_reason

    @flagged_reason.setter
    def flagged_reason(self, flagged_reason: str) -> None:
        """
        Sets the flagged_reason of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param flagged_reason: The flagged_reason of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        if isinstance(flagged_reason, int):
            flagged_reason = str(flagged_reason)
        allowed_values = ["general"]
        if flagged_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flagged_reason -> " + flagged_reason)
            self._flagged_reason = "outdated_sdk_version"
        else:
            self._flagged_reason = flagged_reason

    @property
    def journey_context(self) -> 'QueueConversationScreenShareEventTopicJourneyContext':
        """
        Gets the journey_context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The journey_context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: QueueConversationScreenShareEventTopicJourneyContext
        """
        return self._journey_context

    @journey_context.setter
    def journey_context(self, journey_context: 'QueueConversationScreenShareEventTopicJourneyContext') -> None:
        """
        Sets the journey_context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param journey_context: The journey_context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: QueueConversationScreenShareEventTopicJourneyContext
        """
        

        self._journey_context = journey_context

    @property
    def start_acw_time(self) -> datetime:
        """
        Gets the start_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The start_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._start_acw_time

    @start_acw_time.setter
    def start_acw_time(self, start_acw_time: datetime) -> None:
        """
        Sets the start_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param start_acw_time: The start_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._start_acw_time = start_acw_time

    @property
    def end_acw_time(self) -> datetime:
        """
        Gets the end_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The end_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: datetime
        """
        return self._end_acw_time

    @end_acw_time.setter
    def end_acw_time(self, end_acw_time: datetime) -> None:
        """
        Sets the end_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param end_acw_time: The end_acw_time of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: datetime
        """
        

        self._end_acw_time = end_acw_time

    @property
    def media_roles(self) -> List[str]:
        """
        Gets the media_roles of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The media_roles of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: list[str]
        """
        return self._media_roles

    @media_roles.setter
    def media_roles(self, media_roles: List[str]) -> None:
        """
        Sets the media_roles of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param media_roles: The media_roles of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: list[str]
        """
        

        self._media_roles = media_roles

    @property
    def context(self) -> str:
        """
        Gets the context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context: str) -> None:
        """
        Sets the context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param context: The context of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: str
        """
        

        self._context = context

    @property
    def peer_count(self) -> int:
        """
        Gets the peer_count of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The peer_count of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: int
        """
        return self._peer_count

    @peer_count.setter
    def peer_count(self, peer_count: int) -> None:
        """
        Sets the peer_count of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param peer_count: The peer_count of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: int
        """
        

        self._peer_count = peer_count

    @property
    def sharing(self) -> bool:
        """
        Gets the sharing of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :return: The sharing of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :rtype: bool
        """
        return self._sharing

    @sharing.setter
    def sharing(self, sharing: bool) -> None:
        """
        Sets the sharing of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.


        :param sharing: The sharing of this QueueConversationScreenShareEventTopicScreenShareMediaParticipant.
        :type: bool
        """
        

        self._sharing = sharing

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

