# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class PhonesReboot(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        PhonesReboot - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'phone_ids': 'list[str]',
            'site_id': 'str'
        }

        self.attribute_map = {
            'phone_ids': 'phoneIds',
            'site_id': 'siteId'
        }

        self._phone_ids = None
        self._site_id = None

    @property
    def phone_ids(self) -> List[str]:
        """
        Gets the phone_ids of this PhonesReboot.
        The list of phone Ids to reboot.

        :return: The phone_ids of this PhonesReboot.
        :rtype: list[str]
        """
        return self._phone_ids

    @phone_ids.setter
    def phone_ids(self, phone_ids: List[str]) -> None:
        """
        Sets the phone_ids of this PhonesReboot.
        The list of phone Ids to reboot.

        :param phone_ids: The phone_ids of this PhonesReboot.
        :type: list[str]
        """
        

        self._phone_ids = phone_ids

    @property
    def site_id(self) -> str:
        """
        Gets the site_id of this PhonesReboot.
        ID of the site for which to reboot all phones at that site. no.active.edge and phone.cannot.resolve errors are ignored.

        :return: The site_id of this PhonesReboot.
        :rtype: str
        """
        return self._site_id

    @site_id.setter
    def site_id(self, site_id: str) -> None:
        """
        Sets the site_id of this PhonesReboot.
        ID of the site for which to reboot all phones at that site. no.active.edge and phone.cannot.resolve errors are ignored.

        :param site_id: The site_id of this PhonesReboot.
        :type: str
        """
        

        self._site_id = site_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

