# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ModelingProcessingError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ModelingProcessingError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'internal_error_code': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'internal_error_code': 'internalErrorCode',
            'description': 'description'
        }

        self._internal_error_code = None
        self._description = None

    @property
    def internal_error_code(self) -> str:
        """
        Gets the internal_error_code of this ModelingProcessingError.
        An internal code representing the type of error. ModelInputMissing for 'Model Builder inputs not found.' ModelInputInvalid for 'Model Builder inputs are invalid. Ensure the input data format is correct.' ModelFailed for 'An error occured while building the model with the given input.'

        :return: The internal_error_code of this ModelingProcessingError.
        :rtype: str
        """
        return self._internal_error_code

    @internal_error_code.setter
    def internal_error_code(self, internal_error_code: str) -> None:
        """
        Sets the internal_error_code of this ModelingProcessingError.
        An internal code representing the type of error. ModelInputMissing for 'Model Builder inputs not found.' ModelInputInvalid for 'Model Builder inputs are invalid. Ensure the input data format is correct.' ModelFailed for 'An error occured while building the model with the given input.'

        :param internal_error_code: The internal_error_code of this ModelingProcessingError.
        :type: str
        """
        if isinstance(internal_error_code, int):
            internal_error_code = str(internal_error_code)
        allowed_values = ["ModelInputMissing", "ModelInputInvalid", "ModelFailed"]
        if internal_error_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for internal_error_code -> " + internal_error_code)
            self._internal_error_code = "outdated_sdk_version"
        else:
            self._internal_error_code = internal_error_code

    @property
    def description(self) -> str:
        """
        Gets the description of this ModelingProcessingError.
        A text description of the error

        :return: The description of this ModelingProcessingError.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ModelingProcessingError.
        A text description of the error

        :param description: The description of this ModelingProcessingError.
        :type: str
        """
        

        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

