# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LearningScheduleSlotsQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningScheduleSlotsQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'length_in_minutes': 'int',
            'user_ids': 'list[str]',
            'interruptible_assignment_id': 'str'
        }

        self.attribute_map = {
            'interval': 'interval',
            'length_in_minutes': 'lengthInMinutes',
            'user_ids': 'userIds',
            'interruptible_assignment_id': 'interruptibleAssignmentId'
        }

        self._interval = None
        self._length_in_minutes = None
        self._user_ids = None
        self._interruptible_assignment_id = None

    @property
    def interval(self) -> str:
        """
        Gets the interval of this LearningScheduleSlotsQueryRequest.
        Range of time to get slots for scheduling learning activities. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this LearningScheduleSlotsQueryRequest.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this LearningScheduleSlotsQueryRequest.
        Range of time to get slots for scheduling learning activities. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this LearningScheduleSlotsQueryRequest.
        :type: str
        """
        

        self._interval = interval

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this LearningScheduleSlotsQueryRequest.
        The duration of coaching appointment to schedule in 15 minutes granularity

        :return: The length_in_minutes of this LearningScheduleSlotsQueryRequest.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this LearningScheduleSlotsQueryRequest.
        The duration of coaching appointment to schedule in 15 minutes granularity

        :param length_in_minutes: The length_in_minutes of this LearningScheduleSlotsQueryRequest.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    @property
    def user_ids(self) -> List[str]:
        """
        Gets the user_ids of this LearningScheduleSlotsQueryRequest.
        The user IDs for which to fetch schedules. Must be only 1.

        :return: The user_ids of this LearningScheduleSlotsQueryRequest.
        :rtype: list[str]
        """
        return self._user_ids

    @user_ids.setter
    def user_ids(self, user_ids: List[str]) -> None:
        """
        Sets the user_ids of this LearningScheduleSlotsQueryRequest.
        The user IDs for which to fetch schedules. Must be only 1.

        :param user_ids: The user_ids of this LearningScheduleSlotsQueryRequest.
        :type: list[str]
        """
        

        self._user_ids = user_ids

    @property
    def interruptible_assignment_id(self) -> str:
        """
        Gets the interruptible_assignment_id of this LearningScheduleSlotsQueryRequest.
        Assignment ID to exclude from consideration when determining blocked slots

        :return: The interruptible_assignment_id of this LearningScheduleSlotsQueryRequest.
        :rtype: str
        """
        return self._interruptible_assignment_id

    @interruptible_assignment_id.setter
    def interruptible_assignment_id(self, interruptible_assignment_id: str) -> None:
        """
        Sets the interruptible_assignment_id of this LearningScheduleSlotsQueryRequest.
        Assignment ID to exclude from consideration when determining blocked slots

        :param interruptible_assignment_id: The interruptible_assignment_id of this LearningScheduleSlotsQueryRequest.
        :type: str
        """
        

        self._interruptible_assignment_id = interruptible_assignment_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

