# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AssessmentForm
    from . import LearningModuleCoverArtRequest
    from . import LearningModuleInformStepRequest

class LearningModuleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningModuleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'completion_time_in_days': 'int',
            'inform_steps': 'list[LearningModuleInformStepRequest]',
            'type': 'str',
            'assessment_form': 'AssessmentForm',
            'cover_art': 'LearningModuleCoverArtRequest'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'completion_time_in_days': 'completionTimeInDays',
            'inform_steps': 'informSteps',
            'type': 'type',
            'assessment_form': 'assessmentForm',
            'cover_art': 'coverArt'
        }

        self._name = None
        self._description = None
        self._completion_time_in_days = None
        self._inform_steps = None
        self._type = None
        self._assessment_form = None
        self._cover_art = None

    @property
    def name(self) -> str:
        """
        Gets the name of this LearningModuleRequest.
        The name of learning module

        :return: The name of this LearningModuleRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this LearningModuleRequest.
        The name of learning module

        :param name: The name of this LearningModuleRequest.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this LearningModuleRequest.
        The description of learning module

        :return: The description of this LearningModuleRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this LearningModuleRequest.
        The description of learning module

        :param description: The description of this LearningModuleRequest.
        :type: str
        """
        

        self._description = description

    @property
    def completion_time_in_days(self) -> int:
        """
        Gets the completion_time_in_days of this LearningModuleRequest.
        The completion time of learning module in days

        :return: The completion_time_in_days of this LearningModuleRequest.
        :rtype: int
        """
        return self._completion_time_in_days

    @completion_time_in_days.setter
    def completion_time_in_days(self, completion_time_in_days: int) -> None:
        """
        Sets the completion_time_in_days of this LearningModuleRequest.
        The completion time of learning module in days

        :param completion_time_in_days: The completion_time_in_days of this LearningModuleRequest.
        :type: int
        """
        

        self._completion_time_in_days = completion_time_in_days

    @property
    def inform_steps(self) -> List['LearningModuleInformStepRequest']:
        """
        Gets the inform_steps of this LearningModuleRequest.
        The list of inform steps in a learning module

        :return: The inform_steps of this LearningModuleRequest.
        :rtype: list[LearningModuleInformStepRequest]
        """
        return self._inform_steps

    @inform_steps.setter
    def inform_steps(self, inform_steps: List['LearningModuleInformStepRequest']) -> None:
        """
        Sets the inform_steps of this LearningModuleRequest.
        The list of inform steps in a learning module

        :param inform_steps: The inform_steps of this LearningModuleRequest.
        :type: list[LearningModuleInformStepRequest]
        """
        

        self._inform_steps = inform_steps

    @property
    def type(self) -> str:
        """
        Gets the type of this LearningModuleRequest.
        The type for the learning module

        :return: The type of this LearningModuleRequest.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this LearningModuleRequest.
        The type for the learning module

        :param type: The type of this LearningModuleRequest.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Informational", "AssessedContent", "Assessment", "External"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def assessment_form(self) -> 'AssessmentForm':
        """
        Gets the assessment_form of this LearningModuleRequest.
        The assessment form for learning module

        :return: The assessment_form of this LearningModuleRequest.
        :rtype: AssessmentForm
        """
        return self._assessment_form

    @assessment_form.setter
    def assessment_form(self, assessment_form: 'AssessmentForm') -> None:
        """
        Sets the assessment_form of this LearningModuleRequest.
        The assessment form for learning module

        :param assessment_form: The assessment_form of this LearningModuleRequest.
        :type: AssessmentForm
        """
        

        self._assessment_form = assessment_form

    @property
    def cover_art(self) -> 'LearningModuleCoverArtRequest':
        """
        Gets the cover_art of this LearningModuleRequest.
        The cover art for the learning module

        :return: The cover_art of this LearningModuleRequest.
        :rtype: LearningModuleCoverArtRequest
        """
        return self._cover_art

    @cover_art.setter
    def cover_art(self, cover_art: 'LearningModuleCoverArtRequest') -> None:
        """
        Sets the cover_art of this LearningModuleRequest.
        The cover art for the learning module

        :param cover_art: The cover_art of this LearningModuleRequest.
        :type: LearningModuleCoverArtRequest
        """
        

        self._cover_art = cover_art

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

