# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OutcomeConfig
    from . import WrapUpCodeConfig

class KeyPerformanceIndicator(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KeyPerformanceIndicator - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'optimization_type': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'description': 'str',
            'kpi_type': 'str',
            'source': 'str',
            'wrap_up_code_config': 'WrapUpCodeConfig',
            'outcome_config': 'OutcomeConfig',
            'status': 'str',
            'kpi_group': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'optimization_type': 'optimizationType',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'description': 'description',
            'kpi_type': 'kpiType',
            'source': 'source',
            'wrap_up_code_config': 'wrapUpCodeConfig',
            'outcome_config': 'outcomeConfig',
            'status': 'status',
            'kpi_group': 'kpiGroup',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._optimization_type = None
        self._date_created = None
        self._date_modified = None
        self._description = None
        self._kpi_type = None
        self._source = None
        self._wrap_up_code_config = None
        self._outcome_config = None
        self._status = None
        self._kpi_group = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KeyPerformanceIndicator.
        The globally unique identifier for the object.

        :return: The id of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KeyPerformanceIndicator.
        The globally unique identifier for the object.

        :param id: The id of this KeyPerformanceIndicator.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this KeyPerformanceIndicator.
        The name of the Key Performance Indicator.

        :return: The name of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this KeyPerformanceIndicator.
        The name of the Key Performance Indicator.

        :param name: The name of this KeyPerformanceIndicator.
        :type: str
        """
        

        self._name = name

    @property
    def optimization_type(self) -> str:
        """
        Gets the optimization_type of this KeyPerformanceIndicator.
        The optimization type of the Key Performance Indicator.

        :return: The optimization_type of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._optimization_type

    @optimization_type.setter
    def optimization_type(self, optimization_type: str) -> None:
        """
        Sets the optimization_type of this KeyPerformanceIndicator.
        The optimization type of the Key Performance Indicator.

        :param optimization_type: The optimization_type of this KeyPerformanceIndicator.
        :type: str
        """
        if isinstance(optimization_type, int):
            optimization_type = str(optimization_type)
        allowed_values = ["Maximization", "Minimization"]
        if optimization_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for optimization_type -> " + optimization_type)
            self._optimization_type = "outdated_sdk_version"
        else:
            self._optimization_type = optimization_type

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this KeyPerformanceIndicator.
        DateTime indicating when the Key Performance Indicator was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KeyPerformanceIndicator.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this KeyPerformanceIndicator.
        DateTime indicating when the Key Performance Indicator was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KeyPerformanceIndicator.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this KeyPerformanceIndicator.
        DateTime indicating when the Key Performance Indicator was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KeyPerformanceIndicator.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this KeyPerformanceIndicator.
        DateTime indicating when the Key Performance Indicator was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KeyPerformanceIndicator.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def description(self) -> str:
        """
        Gets the description of this KeyPerformanceIndicator.
        The description of the Key Performance Indicator.

        :return: The description of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this KeyPerformanceIndicator.
        The description of the Key Performance Indicator.

        :param description: The description of this KeyPerformanceIndicator.
        :type: str
        """
        

        self._description = description

    @property
    def kpi_type(self) -> str:
        """
        Gets the kpi_type of this KeyPerformanceIndicator.
        The type of Key Performance Indicator.

        :return: The kpi_type of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._kpi_type

    @kpi_type.setter
    def kpi_type(self, kpi_type: str) -> None:
        """
        Sets the kpi_type of this KeyPerformanceIndicator.
        The type of Key Performance Indicator.

        :param kpi_type: The kpi_type of this KeyPerformanceIndicator.
        :type: str
        """
        if isinstance(kpi_type, int):
            kpi_type = str(kpi_type)
        allowed_values = ["SalesConversion", "Churn", "Retention", "SalesValue", "HandleTime", "NumberOfTransfers"]
        if kpi_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for kpi_type -> " + kpi_type)
            self._kpi_type = "outdated_sdk_version"
        else:
            self._kpi_type = kpi_type

    @property
    def source(self) -> str:
        """
        Gets the source of this KeyPerformanceIndicator.
        Source of values for Key Performance Indicator.

        :return: The source of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source: str) -> None:
        """
        Sets the source of this KeyPerformanceIndicator.
        Source of values for Key Performance Indicator.

        :param source: The source of this KeyPerformanceIndicator.
        :type: str
        """
        if isinstance(source, int):
            source = str(source)
        allowed_values = ["WrapUpCode", "Outcome", "None"]
        if source.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source -> " + source)
            self._source = "outdated_sdk_version"
        else:
            self._source = source

    @property
    def wrap_up_code_config(self) -> 'WrapUpCodeConfig':
        """
        Gets the wrap_up_code_config of this KeyPerformanceIndicator.
        Defines what wrap up codes are mapped to Key Performance Indicator.

        :return: The wrap_up_code_config of this KeyPerformanceIndicator.
        :rtype: WrapUpCodeConfig
        """
        return self._wrap_up_code_config

    @wrap_up_code_config.setter
    def wrap_up_code_config(self, wrap_up_code_config: 'WrapUpCodeConfig') -> None:
        """
        Sets the wrap_up_code_config of this KeyPerformanceIndicator.
        Defines what wrap up codes are mapped to Key Performance Indicator.

        :param wrap_up_code_config: The wrap_up_code_config of this KeyPerformanceIndicator.
        :type: WrapUpCodeConfig
        """
        

        self._wrap_up_code_config = wrap_up_code_config

    @property
    def outcome_config(self) -> 'OutcomeConfig':
        """
        Gets the outcome_config of this KeyPerformanceIndicator.
        Defines what outcome ids are mapped to Key Performance Indicator.

        :return: The outcome_config of this KeyPerformanceIndicator.
        :rtype: OutcomeConfig
        """
        return self._outcome_config

    @outcome_config.setter
    def outcome_config(self, outcome_config: 'OutcomeConfig') -> None:
        """
        Sets the outcome_config of this KeyPerformanceIndicator.
        Defines what outcome ids are mapped to Key Performance Indicator.

        :param outcome_config: The outcome_config of this KeyPerformanceIndicator.
        :type: OutcomeConfig
        """
        

        self._outcome_config = outcome_config

    @property
    def status(self) -> str:
        """
        Gets the status of this KeyPerformanceIndicator.
        The status of the Key Performance Indicator.

        :return: The status of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this KeyPerformanceIndicator.
        The status of the Key Performance Indicator.

        :param status: The status of this KeyPerformanceIndicator.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Enabled", "Disabled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def kpi_group(self) -> str:
        """
        Gets the kpi_group of this KeyPerformanceIndicator.
        The group the Key Performance Indicator belongs to.

        :return: The kpi_group of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._kpi_group

    @kpi_group.setter
    def kpi_group(self, kpi_group: str) -> None:
        """
        Sets the kpi_group of this KeyPerformanceIndicator.
        The group the Key Performance Indicator belongs to.

        :param kpi_group: The kpi_group of this KeyPerformanceIndicator.
        :type: str
        """
        if isinstance(kpi_group, int):
            kpi_group = str(kpi_group)
        allowed_values = ["Standard", "Custom"]
        if kpi_group.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for kpi_group -> " + kpi_group)
            self._kpi_group = "outdated_sdk_version"
        else:
            self._kpi_group = kpi_group

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KeyPerformanceIndicator.
        The URI for this object

        :return: The self_uri of this KeyPerformanceIndicator.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KeyPerformanceIndicator.
        The URI for this object

        :param self_uri: The self_uri of this KeyPerformanceIndicator.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

