# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class JourneyWebEventsNotificationEventAction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyWebEventsNotificationEventAction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'created_date': 'datetime',
            'state': 'str',
            'media_type': 'str',
            'prompt': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'created_date': 'createdDate',
            'state': 'state',
            'media_type': 'mediaType',
            'prompt': 'prompt'
        }

        self._id = None
        self._created_date = None
        self._state = None
        self._media_type = None
        self._prompt = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneyWebEventsNotificationEventAction.


        :return: The id of this JourneyWebEventsNotificationEventAction.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneyWebEventsNotificationEventAction.


        :param id: The id of this JourneyWebEventsNotificationEventAction.
        :type: str
        """
        

        self._id = id

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this JourneyWebEventsNotificationEventAction.


        :return: The created_date of this JourneyWebEventsNotificationEventAction.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this JourneyWebEventsNotificationEventAction.


        :param created_date: The created_date of this JourneyWebEventsNotificationEventAction.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def state(self) -> str:
        """
        Gets the state of this JourneyWebEventsNotificationEventAction.


        :return: The state of this JourneyWebEventsNotificationEventAction.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this JourneyWebEventsNotificationEventAction.


        :param state: The state of this JourneyWebEventsNotificationEventAction.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["accepted", "rejected", "timedout", "errored", "ignored", "qualified", "offered", "started", "engaged", "qualifiedOutsideSchedule", "offeredOutsideSchedule", "abandoned", "completed", "frequencyCapReached"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this JourneyWebEventsNotificationEventAction.


        :return: The media_type of this JourneyWebEventsNotificationEventAction.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this JourneyWebEventsNotificationEventAction.


        :param media_type: The media_type of this JourneyWebEventsNotificationEventAction.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["webchat", "webMessagingOffer", "contentOffer", "architectFlow"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def prompt(self) -> str:
        """
        Gets the prompt of this JourneyWebEventsNotificationEventAction.


        :return: The prompt of this JourneyWebEventsNotificationEventAction.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt: str) -> None:
        """
        Sets the prompt of this JourneyWebEventsNotificationEventAction.


        :param prompt: The prompt of this JourneyWebEventsNotificationEventAction.
        :type: str
        """
        

        self._prompt = prompt

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

