# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AudioState

class InitialConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InitialConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'audio_state': 'AudioState',
            'alerting': 'bool',
            'inbound': 'bool',
            'invited_by': 'str',
            'recording_active': 'bool',
            'additional_info': 'dict(str, str)'
        }

        self.attribute_map = {
            'audio_state': 'audioState',
            'alerting': 'alerting',
            'inbound': 'inbound',
            'invited_by': 'invitedBy',
            'recording_active': 'recordingActive',
            'additional_info': 'additionalInfo'
        }

        self._audio_state = None
        self._alerting = None
        self._inbound = None
        self._invited_by = None
        self._recording_active = None
        self._additional_info = None

    @property
    def audio_state(self) -> 'AudioState':
        """
        Gets the audio_state of this InitialConfiguration.
        Indicates the initial audio state for the communication.

        :return: The audio_state of this InitialConfiguration.
        :rtype: AudioState
        """
        return self._audio_state

    @audio_state.setter
    def audio_state(self, audio_state: 'AudioState') -> None:
        """
        Sets the audio_state of this InitialConfiguration.
        Indicates the initial audio state for the communication.

        :param audio_state: The audio_state of this InitialConfiguration.
        :type: AudioState
        """
        

        self._audio_state = audio_state

    @property
    def alerting(self) -> bool:
        """
        Gets the alerting of this InitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :return: The alerting of this InitialConfiguration.
        :rtype: bool
        """
        return self._alerting

    @alerting.setter
    def alerting(self, alerting: bool) -> None:
        """
        Sets the alerting of this InitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :param alerting: The alerting of this InitialConfiguration.
        :type: bool
        """
        

        self._alerting = alerting

    @property
    def inbound(self) -> bool:
        """
        Gets the inbound of this InitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :return: The inbound of this InitialConfiguration.
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound: bool) -> None:
        """
        Sets the inbound of this InitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :param inbound: The inbound of this InitialConfiguration.
        :type: bool
        """
        

        self._inbound = inbound

    @property
    def invited_by(self) -> str:
        """
        Gets the invited_by of this InitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :return: The invited_by of this InitialConfiguration.
        :rtype: str
        """
        return self._invited_by

    @invited_by.setter
    def invited_by(self, invited_by: str) -> None:
        """
        Sets the invited_by of this InitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :param invited_by: The invited_by of this InitialConfiguration.
        :type: str
        """
        

        self._invited_by = invited_by

    @property
    def recording_active(self) -> bool:
        """
        Gets the recording_active of this InitialConfiguration.
        Indicates whether recording is active for this communication at creation.

        :return: The recording_active of this InitialConfiguration.
        :rtype: bool
        """
        return self._recording_active

    @recording_active.setter
    def recording_active(self, recording_active: bool) -> None:
        """
        Sets the recording_active of this InitialConfiguration.
        Indicates whether recording is active for this communication at creation.

        :param recording_active: The recording_active of this InitialConfiguration.
        :type: bool
        """
        

        self._recording_active = recording_active

    @property
    def additional_info(self) -> Dict[str, str]:
        """
        Gets the additional_info of this InitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :return: The additional_info of this InitialConfiguration.
        :rtype: dict(str, str)
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info: Dict[str, str]) -> None:
        """
        Sets the additional_info of this InitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :param additional_info: The additional_info of this InitialConfiguration.
        :type: dict(str, str)
        """
        

        self._additional_info = additional_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

