# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FacetStatistics
    from . import FacetTerm
    from . import TermAttribute

class FacetEntry(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FacetEntry - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'attribute': 'TermAttribute',
            'statistics': 'FacetStatistics',
            'other': 'int',
            'total': 'int',
            'missing': 'int',
            'term_count': 'int',
            'term_type': 'str',
            'terms': 'list[FacetTerm]'
        }

        self.attribute_map = {
            'attribute': 'attribute',
            'statistics': 'statistics',
            'other': 'other',
            'total': 'total',
            'missing': 'missing',
            'term_count': 'termCount',
            'term_type': 'termType',
            'terms': 'terms'
        }

        self._attribute = None
        self._statistics = None
        self._other = None
        self._total = None
        self._missing = None
        self._term_count = None
        self._term_type = None
        self._terms = None

    @property
    def attribute(self) -> 'TermAttribute':
        """
        Gets the attribute of this FacetEntry.


        :return: The attribute of this FacetEntry.
        :rtype: TermAttribute
        """
        return self._attribute

    @attribute.setter
    def attribute(self, attribute: 'TermAttribute') -> None:
        """
        Sets the attribute of this FacetEntry.


        :param attribute: The attribute of this FacetEntry.
        :type: TermAttribute
        """
        

        self._attribute = attribute

    @property
    def statistics(self) -> 'FacetStatistics':
        """
        Gets the statistics of this FacetEntry.


        :return: The statistics of this FacetEntry.
        :rtype: FacetStatistics
        """
        return self._statistics

    @statistics.setter
    def statistics(self, statistics: 'FacetStatistics') -> None:
        """
        Sets the statistics of this FacetEntry.


        :param statistics: The statistics of this FacetEntry.
        :type: FacetStatistics
        """
        

        self._statistics = statistics

    @property
    def other(self) -> int:
        """
        Gets the other of this FacetEntry.


        :return: The other of this FacetEntry.
        :rtype: int
        """
        return self._other

    @other.setter
    def other(self, other: int) -> None:
        """
        Sets the other of this FacetEntry.


        :param other: The other of this FacetEntry.
        :type: int
        """
        

        self._other = other

    @property
    def total(self) -> int:
        """
        Gets the total of this FacetEntry.


        :return: The total of this FacetEntry.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total: int) -> None:
        """
        Sets the total of this FacetEntry.


        :param total: The total of this FacetEntry.
        :type: int
        """
        

        self._total = total

    @property
    def missing(self) -> int:
        """
        Gets the missing of this FacetEntry.


        :return: The missing of this FacetEntry.
        :rtype: int
        """
        return self._missing

    @missing.setter
    def missing(self, missing: int) -> None:
        """
        Sets the missing of this FacetEntry.


        :param missing: The missing of this FacetEntry.
        :type: int
        """
        

        self._missing = missing

    @property
    def term_count(self) -> int:
        """
        Gets the term_count of this FacetEntry.


        :return: The term_count of this FacetEntry.
        :rtype: int
        """
        return self._term_count

    @term_count.setter
    def term_count(self, term_count: int) -> None:
        """
        Sets the term_count of this FacetEntry.


        :param term_count: The term_count of this FacetEntry.
        :type: int
        """
        

        self._term_count = term_count

    @property
    def term_type(self) -> str:
        """
        Gets the term_type of this FacetEntry.


        :return: The term_type of this FacetEntry.
        :rtype: str
        """
        return self._term_type

    @term_type.setter
    def term_type(self, term_type: str) -> None:
        """
        Sets the term_type of this FacetEntry.


        :param term_type: The term_type of this FacetEntry.
        :type: str
        """
        if isinstance(term_type, int):
            term_type = str(term_type)
        allowed_values = ["TERM", "NUMBERRANGE", "NUMBERHISTOGRAM", "DATERANGE", "DATEHISTOGRAM", "ID"]
        if term_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for term_type -> " + term_type)
            self._term_type = "outdated_sdk_version"
        else:
            self._term_type = term_type

    @property
    def terms(self) -> List['FacetTerm']:
        """
        Gets the terms of this FacetEntry.


        :return: The terms of this FacetEntry.
        :rtype: list[FacetTerm]
        """
        return self._terms

    @terms.setter
    def terms(self, terms: List['FacetTerm']) -> None:
        """
        Sets the terms of this FacetEntry.


        :param terms: The terms of this FacetEntry.
        :type: list[FacetTerm]
        """
        

        self._terms = terms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

