# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class DevelopmentActivity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DevelopmentActivity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_completed': 'datetime',
            'created_by': 'UserReference',
            'date_created': 'datetime',
            'percentage_score': 'float',
            'is_passed': 'bool',
            'is_latest': 'bool',
            'self_uri': 'str',
            'name': 'str',
            'type': 'str',
            'status': 'str',
            'date_due': 'datetime',
            'facilitator': 'UserReference',
            'attendees': 'list[UserReference]',
            'is_overdue': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'date_completed': 'dateCompleted',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'percentage_score': 'percentageScore',
            'is_passed': 'isPassed',
            'is_latest': 'isLatest',
            'self_uri': 'selfUri',
            'name': 'name',
            'type': 'type',
            'status': 'status',
            'date_due': 'dateDue',
            'facilitator': 'facilitator',
            'attendees': 'attendees',
            'is_overdue': 'isOverdue'
        }

        self._id = None
        self._date_completed = None
        self._created_by = None
        self._date_created = None
        self._percentage_score = None
        self._is_passed = None
        self._is_latest = None
        self._self_uri = None
        self._name = None
        self._type = None
        self._status = None
        self._date_due = None
        self._facilitator = None
        self._attendees = None
        self._is_overdue = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DevelopmentActivity.
        The globally unique identifier for the object.

        :return: The id of this DevelopmentActivity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DevelopmentActivity.
        The globally unique identifier for the object.

        :param id: The id of this DevelopmentActivity.
        :type: str
        """
        

        self._id = id

    @property
    def date_completed(self) -> datetime:
        """
        Gets the date_completed of this DevelopmentActivity.
        Date that activity was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_completed of this DevelopmentActivity.
        :rtype: datetime
        """
        return self._date_completed

    @date_completed.setter
    def date_completed(self, date_completed: datetime) -> None:
        """
        Sets the date_completed of this DevelopmentActivity.
        Date that activity was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_completed: The date_completed of this DevelopmentActivity.
        :type: datetime
        """
        

        self._date_completed = date_completed

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this DevelopmentActivity.
        User that created activity

        :return: The created_by of this DevelopmentActivity.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this DevelopmentActivity.
        User that created activity

        :param created_by: The created_by of this DevelopmentActivity.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this DevelopmentActivity.
        Date activity was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this DevelopmentActivity.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this DevelopmentActivity.
        Date activity was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this DevelopmentActivity.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def percentage_score(self) -> float:
        """
        Gets the percentage_score of this DevelopmentActivity.
        The user's percentage score for this activity

        :return: The percentage_score of this DevelopmentActivity.
        :rtype: float
        """
        return self._percentage_score

    @percentage_score.setter
    def percentage_score(self, percentage_score: float) -> None:
        """
        Sets the percentage_score of this DevelopmentActivity.
        The user's percentage score for this activity

        :param percentage_score: The percentage_score of this DevelopmentActivity.
        :type: float
        """
        

        self._percentage_score = percentage_score

    @property
    def is_passed(self) -> bool:
        """
        Gets the is_passed of this DevelopmentActivity.
        True if the activity was passed

        :return: The is_passed of this DevelopmentActivity.
        :rtype: bool
        """
        return self._is_passed

    @is_passed.setter
    def is_passed(self, is_passed: bool) -> None:
        """
        Sets the is_passed of this DevelopmentActivity.
        True if the activity was passed

        :param is_passed: The is_passed of this DevelopmentActivity.
        :type: bool
        """
        

        self._is_passed = is_passed

    @property
    def is_latest(self) -> bool:
        """
        Gets the is_latest of this DevelopmentActivity.
        True if this is the latest version of assignment assigned to the user

        :return: The is_latest of this DevelopmentActivity.
        :rtype: bool
        """
        return self._is_latest

    @is_latest.setter
    def is_latest(self, is_latest: bool) -> None:
        """
        Sets the is_latest of this DevelopmentActivity.
        True if this is the latest version of assignment assigned to the user

        :param is_latest: The is_latest of this DevelopmentActivity.
        :type: bool
        """
        

        self._is_latest = is_latest

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DevelopmentActivity.
        The URI for this object

        :return: The self_uri of this DevelopmentActivity.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DevelopmentActivity.
        The URI for this object

        :param self_uri: The self_uri of this DevelopmentActivity.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def name(self) -> str:
        """
        Gets the name of this DevelopmentActivity.
        The name of the activity

        :return: The name of this DevelopmentActivity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DevelopmentActivity.
        The name of the activity

        :param name: The name of this DevelopmentActivity.
        :type: str
        """
        

        self._name = name

    @property
    def type(self) -> str:
        """
        Gets the type of this DevelopmentActivity.
        The type of activity

        :return: The type of this DevelopmentActivity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this DevelopmentActivity.
        The type of activity

        :param type: The type of this DevelopmentActivity.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Informational", "Coaching", "AssessedContent", "Assessment", "External"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def status(self) -> str:
        """
        Gets the status of this DevelopmentActivity.
        The status of the activity

        :return: The status of this DevelopmentActivity.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this DevelopmentActivity.
        The status of the activity

        :param status: The status of this DevelopmentActivity.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Planned", "InProgress", "Completed", "InvalidSchedule", "NotCompleted"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def date_due(self) -> datetime:
        """
        Gets the date_due of this DevelopmentActivity.
        Due date for completion of the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_due of this DevelopmentActivity.
        :rtype: datetime
        """
        return self._date_due

    @date_due.setter
    def date_due(self, date_due: datetime) -> None:
        """
        Sets the date_due of this DevelopmentActivity.
        Due date for completion of the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_due: The date_due of this DevelopmentActivity.
        :type: datetime
        """
        

        self._date_due = date_due

    @property
    def facilitator(self) -> 'UserReference':
        """
        Gets the facilitator of this DevelopmentActivity.
        Facilitator of the activity

        :return: The facilitator of this DevelopmentActivity.
        :rtype: UserReference
        """
        return self._facilitator

    @facilitator.setter
    def facilitator(self, facilitator: 'UserReference') -> None:
        """
        Sets the facilitator of this DevelopmentActivity.
        Facilitator of the activity

        :param facilitator: The facilitator of this DevelopmentActivity.
        :type: UserReference
        """
        

        self._facilitator = facilitator

    @property
    def attendees(self) -> List['UserReference']:
        """
        Gets the attendees of this DevelopmentActivity.
        List of users attending the activity

        :return: The attendees of this DevelopmentActivity.
        :rtype: list[UserReference]
        """
        return self._attendees

    @attendees.setter
    def attendees(self, attendees: List['UserReference']) -> None:
        """
        Sets the attendees of this DevelopmentActivity.
        List of users attending the activity

        :param attendees: The attendees of this DevelopmentActivity.
        :type: list[UserReference]
        """
        

        self._attendees = attendees

    @property
    def is_overdue(self) -> bool:
        """
        Gets the is_overdue of this DevelopmentActivity.
        Indicates if the activity is overdue

        :return: The is_overdue of this DevelopmentActivity.
        :rtype: bool
        """
        return self._is_overdue

    @is_overdue.setter
    def is_overdue(self, is_overdue: bool) -> None:
        """
        Sets the is_overdue of this DevelopmentActivity.
        Indicates if the activity is overdue

        :param is_overdue: The is_overdue of this DevelopmentActivity.
        :type: bool
        """
        

        self._is_overdue = is_overdue

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

