# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DailyPossibleShift(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DailyPossibleShift - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'day_of_week': 'str',
            'earliest_shift_start_minutes_from_midnight': 'int',
            'required': 'bool',
            'minimum_paid_time_minutes': 'int',
            'maximum_paid_time_minutes': 'int',
            'interval_schedule_probabilities': 'list[int]'
        }

        self.attribute_map = {
            'day_of_week': 'dayOfWeek',
            'earliest_shift_start_minutes_from_midnight': 'earliestShiftStartMinutesFromMidnight',
            'required': 'required',
            'minimum_paid_time_minutes': 'minimumPaidTimeMinutes',
            'maximum_paid_time_minutes': 'maximumPaidTimeMinutes',
            'interval_schedule_probabilities': 'intervalScheduleProbabilities'
        }

        self._day_of_week = None
        self._earliest_shift_start_minutes_from_midnight = None
        self._required = None
        self._minimum_paid_time_minutes = None
        self._maximum_paid_time_minutes = None
        self._interval_schedule_probabilities = None

    @property
    def day_of_week(self) -> str:
        """
        Gets the day_of_week of this DailyPossibleShift.
        Day of the shift

        :return: The day_of_week of this DailyPossibleShift.
        :rtype: str
        """
        return self._day_of_week

    @day_of_week.setter
    def day_of_week(self, day_of_week: str) -> None:
        """
        Sets the day_of_week of this DailyPossibleShift.
        Day of the shift

        :param day_of_week: The day_of_week of this DailyPossibleShift.
        :type: str
        """
        if isinstance(day_of_week, int):
            day_of_week = str(day_of_week)
        allowed_values = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
        if day_of_week.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for day_of_week -> " + day_of_week)
            self._day_of_week = "outdated_sdk_version"
        else:
            self._day_of_week = day_of_week

    @property
    def earliest_shift_start_minutes_from_midnight(self) -> int:
        """
        Gets the earliest_shift_start_minutes_from_midnight of this DailyPossibleShift.
        Minutes of the earliest shift start from midnight. Note that midnight is 12:00 am in the time zone specified in the timeZone field (in the top level of the response)

        :return: The earliest_shift_start_minutes_from_midnight of this DailyPossibleShift.
        :rtype: int
        """
        return self._earliest_shift_start_minutes_from_midnight

    @earliest_shift_start_minutes_from_midnight.setter
    def earliest_shift_start_minutes_from_midnight(self, earliest_shift_start_minutes_from_midnight: int) -> None:
        """
        Sets the earliest_shift_start_minutes_from_midnight of this DailyPossibleShift.
        Minutes of the earliest shift start from midnight. Note that midnight is 12:00 am in the time zone specified in the timeZone field (in the top level of the response)

        :param earliest_shift_start_minutes_from_midnight: The earliest_shift_start_minutes_from_midnight of this DailyPossibleShift.
        :type: int
        """
        

        self._earliest_shift_start_minutes_from_midnight = earliest_shift_start_minutes_from_midnight

    @property
    def required(self) -> bool:
        """
        Gets the required of this DailyPossibleShift.
        Whether this is a required shift

        :return: The required of this DailyPossibleShift.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required: bool) -> None:
        """
        Sets the required of this DailyPossibleShift.
        Whether this is a required shift

        :param required: The required of this DailyPossibleShift.
        :type: bool
        """
        

        self._required = required

    @property
    def minimum_paid_time_minutes(self) -> int:
        """
        Gets the minimum_paid_time_minutes of this DailyPossibleShift.
        Minimum paid time in minutes of this daily shift

        :return: The minimum_paid_time_minutes of this DailyPossibleShift.
        :rtype: int
        """
        return self._minimum_paid_time_minutes

    @minimum_paid_time_minutes.setter
    def minimum_paid_time_minutes(self, minimum_paid_time_minutes: int) -> None:
        """
        Sets the minimum_paid_time_minutes of this DailyPossibleShift.
        Minimum paid time in minutes of this daily shift

        :param minimum_paid_time_minutes: The minimum_paid_time_minutes of this DailyPossibleShift.
        :type: int
        """
        

        self._minimum_paid_time_minutes = minimum_paid_time_minutes

    @property
    def maximum_paid_time_minutes(self) -> int:
        """
        Gets the maximum_paid_time_minutes of this DailyPossibleShift.
        Maximum paid time in minutes of this daily shift

        :return: The maximum_paid_time_minutes of this DailyPossibleShift.
        :rtype: int
        """
        return self._maximum_paid_time_minutes

    @maximum_paid_time_minutes.setter
    def maximum_paid_time_minutes(self, maximum_paid_time_minutes: int) -> None:
        """
        Sets the maximum_paid_time_minutes of this DailyPossibleShift.
        Maximum paid time in minutes of this daily shift

        :param maximum_paid_time_minutes: The maximum_paid_time_minutes of this DailyPossibleShift.
        :type: int
        """
        

        self._maximum_paid_time_minutes = maximum_paid_time_minutes

    @property
    def interval_schedule_probabilities(self) -> List[int]:
        """
        Gets the interval_schedule_probabilities of this DailyPossibleShift.
        The percentage of being scheduled in each interval between the earliest shift start and latest shift end. Range of the values: [0, 100].

        :return: The interval_schedule_probabilities of this DailyPossibleShift.
        :rtype: list[int]
        """
        return self._interval_schedule_probabilities

    @interval_schedule_probabilities.setter
    def interval_schedule_probabilities(self, interval_schedule_probabilities: List[int]) -> None:
        """
        Sets the interval_schedule_probabilities of this DailyPossibleShift.
        The percentage of being scheduled in each interval between the earliest shift start and latest shift end. Range of the values: [0, 100].

        :param interval_schedule_probabilities: The interval_schedule_probabilities of this DailyPossibleShift.
        :type: list[int]
        """
        

        self._interval_schedule_probabilities = interval_schedule_probabilities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

