# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContactColumnTimeZone(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactColumnTimeZone - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'time_zone': 'str',
            'column_type': 'str'
        }

        self.attribute_map = {
            'time_zone': 'timeZone',
            'column_type': 'columnType'
        }

        self._time_zone = None
        self._column_type = None

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this ContactColumnTimeZone.
        Time zone that the column matched to. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :return: The time_zone of this ContactColumnTimeZone.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this ContactColumnTimeZone.
        Time zone that the column matched to. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :param time_zone: The time_zone of this ContactColumnTimeZone.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def column_type(self) -> str:
        """
        Gets the column_type of this ContactColumnTimeZone.
        Column Type will be either PHONE or ZIP

        :return: The column_type of this ContactColumnTimeZone.
        :rtype: str
        """
        return self._column_type

    @column_type.setter
    def column_type(self, column_type: str) -> None:
        """
        Sets the column_type of this ContactColumnTimeZone.
        Column Type will be either PHONE or ZIP

        :param column_type: The column_type of this ContactColumnTimeZone.
        :type: str
        """
        if isinstance(column_type, int):
            column_type = str(column_type)
        allowed_values = ["PHONE", "ZIP"]
        if column_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for column_type -> " + column_type)
            self._column_type = "outdated_sdk_version"
        else:
            self._column_type = column_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

