# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CategoryReference
    from . import KnowledgeBaseReference

class CategoryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CategoryResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'parent_category': 'CategoryReference',
            'document_count': 'int',
            'knowledge_base': 'KnowledgeBaseReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'parent_category': 'parentCategory',
            'document_count': 'documentCount',
            'knowledge_base': 'knowledgeBase',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._date_created = None
        self._date_modified = None
        self._parent_category = None
        self._document_count = None
        self._knowledge_base = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CategoryResponse.
        The globally unique identifier for the object.

        :return: The id of this CategoryResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CategoryResponse.
        The globally unique identifier for the object.

        :param id: The id of this CategoryResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CategoryResponse.
        The name of the category.

        :return: The name of this CategoryResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CategoryResponse.
        The name of the category.

        :param name: The name of this CategoryResponse.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this CategoryResponse.
        The description for the category.

        :return: The description of this CategoryResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this CategoryResponse.
        The description for the category.

        :param description: The description of this CategoryResponse.
        :type: str
        """
        

        self._description = description

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this CategoryResponse.
        The creation date-time for the category. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this CategoryResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this CategoryResponse.
        The creation date-time for the category. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this CategoryResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this CategoryResponse.
        The last modification date-time for the category. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this CategoryResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this CategoryResponse.
        The last modification date-time for the category. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this CategoryResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def parent_category(self) -> 'CategoryReference':
        """
        Gets the parent_category of this CategoryResponse.
        The reference to category to which this category belongs to.

        :return: The parent_category of this CategoryResponse.
        :rtype: CategoryReference
        """
        return self._parent_category

    @parent_category.setter
    def parent_category(self, parent_category: 'CategoryReference') -> None:
        """
        Sets the parent_category of this CategoryResponse.
        The reference to category to which this category belongs to.

        :param parent_category: The parent_category of this CategoryResponse.
        :type: CategoryReference
        """
        

        self._parent_category = parent_category

    @property
    def document_count(self) -> int:
        """
        Gets the document_count of this CategoryResponse.
        Number of documents assigned to this category.

        :return: The document_count of this CategoryResponse.
        :rtype: int
        """
        return self._document_count

    @document_count.setter
    def document_count(self, document_count: int) -> None:
        """
        Sets the document_count of this CategoryResponse.
        Number of documents assigned to this category.

        :param document_count: The document_count of this CategoryResponse.
        :type: int
        """
        

        self._document_count = document_count

    @property
    def knowledge_base(self) -> 'KnowledgeBaseReference':
        """
        Gets the knowledge_base of this CategoryResponse.
        The reference to knowledge base to which the category belongs to.

        :return: The knowledge_base of this CategoryResponse.
        :rtype: KnowledgeBaseReference
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base: 'KnowledgeBaseReference') -> None:
        """
        Sets the knowledge_base of this CategoryResponse.
        The reference to knowledge base to which the category belongs to.

        :param knowledge_base: The knowledge_base of this CategoryResponse.
        :type: KnowledgeBaseReference
        """
        

        self._knowledge_base = knowledge_base

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CategoryResponse.
        The URI for this object

        :return: The self_uri of this CategoryResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CategoryResponse.
        The URI for this object

        :param self_uri: The self_uri of this CategoryResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

