# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AnalyticsEvaluation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AnalyticsEvaluation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'calibration_id': 'str',
            'context_id': 'str',
            'deleted': 'bool',
            'evaluation_id': 'str',
            'evaluation_status': 'str',
            'evaluator_id': 'str',
            'event_time': 'datetime',
            'form_id': 'str',
            'form_name': 'str',
            'queue_id': 'str',
            'released': 'bool',
            'rescored': 'bool',
            'user_id': 'str',
            'o_total_critical_score': 'int',
            'o_total_score': 'int'
        }

        self.attribute_map = {
            'calibration_id': 'calibrationId',
            'context_id': 'contextId',
            'deleted': 'deleted',
            'evaluation_id': 'evaluationId',
            'evaluation_status': 'evaluationStatus',
            'evaluator_id': 'evaluatorId',
            'event_time': 'eventTime',
            'form_id': 'formId',
            'form_name': 'formName',
            'queue_id': 'queueId',
            'released': 'released',
            'rescored': 'rescored',
            'user_id': 'userId',
            'o_total_critical_score': 'oTotalCriticalScore',
            'o_total_score': 'oTotalScore'
        }

        self._calibration_id = None
        self._context_id = None
        self._deleted = None
        self._evaluation_id = None
        self._evaluation_status = None
        self._evaluator_id = None
        self._event_time = None
        self._form_id = None
        self._form_name = None
        self._queue_id = None
        self._released = None
        self._rescored = None
        self._user_id = None
        self._o_total_critical_score = None
        self._o_total_score = None

    @property
    def calibration_id(self) -> str:
        """
        Gets the calibration_id of this AnalyticsEvaluation.
        The calibration ID used for the purpose of training evaluators

        :return: The calibration_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._calibration_id

    @calibration_id.setter
    def calibration_id(self, calibration_id: str) -> None:
        """
        Sets the calibration_id of this AnalyticsEvaluation.
        The calibration ID used for the purpose of training evaluators

        :param calibration_id: The calibration_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._calibration_id = calibration_id

    @property
    def context_id(self) -> str:
        """
        Gets the context_id of this AnalyticsEvaluation.
        A unique identifier for an evaluation form, regardless of version

        :return: The context_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id: str) -> None:
        """
        Sets the context_id of this AnalyticsEvaluation.
        A unique identifier for an evaluation form, regardless of version

        :param context_id: The context_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._context_id = context_id

    @property
    def deleted(self) -> bool:
        """
        Gets the deleted of this AnalyticsEvaluation.
        Whether the evaluation has been deleted

        :return: The deleted of this AnalyticsEvaluation.
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted: bool) -> None:
        """
        Sets the deleted of this AnalyticsEvaluation.
        Whether the evaluation has been deleted

        :param deleted: The deleted of this AnalyticsEvaluation.
        :type: bool
        """
        

        self._deleted = deleted

    @property
    def evaluation_id(self) -> str:
        """
        Gets the evaluation_id of this AnalyticsEvaluation.
        Unique identifier for the evaluation

        :return: The evaluation_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._evaluation_id

    @evaluation_id.setter
    def evaluation_id(self, evaluation_id: str) -> None:
        """
        Sets the evaluation_id of this AnalyticsEvaluation.
        Unique identifier for the evaluation

        :param evaluation_id: The evaluation_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._evaluation_id = evaluation_id

    @property
    def evaluation_status(self) -> str:
        """
        Gets the evaluation_status of this AnalyticsEvaluation.
        Status of evaluation

        :return: The evaluation_status of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._evaluation_status

    @evaluation_status.setter
    def evaluation_status(self, evaluation_status: str) -> None:
        """
        Sets the evaluation_status of this AnalyticsEvaluation.
        Status of evaluation

        :param evaluation_status: The evaluation_status of this AnalyticsEvaluation.
        :type: str
        """
        if isinstance(evaluation_status, int):
            evaluation_status = str(evaluation_status)
        allowed_values = ["Finished", "InProgress", "InReview", "Pending", "Retracted"]
        if evaluation_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for evaluation_status -> " + evaluation_status)
            self._evaluation_status = "outdated_sdk_version"
        else:
            self._evaluation_status = evaluation_status

    @property
    def evaluator_id(self) -> str:
        """
        Gets the evaluator_id of this AnalyticsEvaluation.
        A unique identifier of the user who evaluated the interaction

        :return: The evaluator_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._evaluator_id

    @evaluator_id.setter
    def evaluator_id(self, evaluator_id: str) -> None:
        """
        Sets the evaluator_id of this AnalyticsEvaluation.
        A unique identifier of the user who evaluated the interaction

        :param evaluator_id: The evaluator_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._evaluator_id = evaluator_id

    @property
    def event_time(self) -> datetime:
        """
        Gets the event_time of this AnalyticsEvaluation.
        Specifies when an evaluation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The event_time of this AnalyticsEvaluation.
        :rtype: datetime
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time: datetime) -> None:
        """
        Sets the event_time of this AnalyticsEvaluation.
        Specifies when an evaluation occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param event_time: The event_time of this AnalyticsEvaluation.
        :type: datetime
        """
        

        self._event_time = event_time

    @property
    def form_id(self) -> str:
        """
        Gets the form_id of this AnalyticsEvaluation.
        ID of the evaluation form used

        :return: The form_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._form_id

    @form_id.setter
    def form_id(self, form_id: str) -> None:
        """
        Sets the form_id of this AnalyticsEvaluation.
        ID of the evaluation form used

        :param form_id: The form_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._form_id = form_id

    @property
    def form_name(self) -> str:
        """
        Gets the form_name of this AnalyticsEvaluation.
        Name of the evaluation form used

        :return: The form_name of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._form_name

    @form_name.setter
    def form_name(self, form_name: str) -> None:
        """
        Sets the form_name of this AnalyticsEvaluation.
        Name of the evaluation form used

        :param form_name: The form_name of this AnalyticsEvaluation.
        :type: str
        """
        

        self._form_name = form_name

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this AnalyticsEvaluation.
        The ID of the associated queue

        :return: The queue_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this AnalyticsEvaluation.
        The ID of the associated queue

        :param queue_id: The queue_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def released(self) -> bool:
        """
        Gets the released of this AnalyticsEvaluation.
        Whether the evaluation has been released

        :return: The released of this AnalyticsEvaluation.
        :rtype: bool
        """
        return self._released

    @released.setter
    def released(self, released: bool) -> None:
        """
        Sets the released of this AnalyticsEvaluation.
        Whether the evaluation has been released

        :param released: The released of this AnalyticsEvaluation.
        :type: bool
        """
        

        self._released = released

    @property
    def rescored(self) -> bool:
        """
        Gets the rescored of this AnalyticsEvaluation.
        Whether the evaluation has been rescored at least once

        :return: The rescored of this AnalyticsEvaluation.
        :rtype: bool
        """
        return self._rescored

    @rescored.setter
    def rescored(self, rescored: bool) -> None:
        """
        Sets the rescored of this AnalyticsEvaluation.
        Whether the evaluation has been rescored at least once

        :param rescored: The rescored of this AnalyticsEvaluation.
        :type: bool
        """
        

        self._rescored = rescored

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this AnalyticsEvaluation.
        ID of the agent the evaluation was performed against

        :return: The user_id of this AnalyticsEvaluation.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this AnalyticsEvaluation.
        ID of the agent the evaluation was performed against

        :param user_id: The user_id of this AnalyticsEvaluation.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def o_total_critical_score(self) -> int:
        """
        Gets the o_total_critical_score of this AnalyticsEvaluation.


        :return: The o_total_critical_score of this AnalyticsEvaluation.
        :rtype: int
        """
        return self._o_total_critical_score

    @o_total_critical_score.setter
    def o_total_critical_score(self, o_total_critical_score: int) -> None:
        """
        Sets the o_total_critical_score of this AnalyticsEvaluation.


        :param o_total_critical_score: The o_total_critical_score of this AnalyticsEvaluation.
        :type: int
        """
        

        self._o_total_critical_score = o_total_critical_score

    @property
    def o_total_score(self) -> int:
        """
        Gets the o_total_score of this AnalyticsEvaluation.


        :return: The o_total_score of this AnalyticsEvaluation.
        :rtype: int
        """
        return self._o_total_score

    @o_total_score.setter
    def o_total_score(self, o_total_score: int) -> None:
        """
        Sets the o_total_score of this AnalyticsEvaluation.


        :param o_total_score: The o_total_score of this AnalyticsEvaluation.
        :type: int
        """
        

        self._o_total_score = o_total_score

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

