# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AddAdherenceExplanationAdminRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AddAdherenceExplanationAdminRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'start_date': 'datetime',
            'length_minutes': 'int',
            'notes': 'str',
            'status': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'start_date': 'startDate',
            'length_minutes': 'lengthMinutes',
            'notes': 'notes',
            'status': 'status'
        }

        self._type = None
        self._start_date = None
        self._length_minutes = None
        self._notes = None
        self._status = None

    @property
    def type(self) -> str:
        """
        Gets the type of this AddAdherenceExplanationAdminRequest.
        The type of the adherence explanation

        :return: The type of this AddAdherenceExplanationAdminRequest.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this AddAdherenceExplanationAdminRequest.
        The type of the adherence explanation

        :param type: The type of this AddAdherenceExplanationAdminRequest.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Late"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this AddAdherenceExplanationAdminRequest.
        The start timestamp of the adherence explanation in ISO-8601 format

        :return: The start_date of this AddAdherenceExplanationAdminRequest.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this AddAdherenceExplanationAdminRequest.
        The start timestamp of the adherence explanation in ISO-8601 format

        :param start_date: The start_date of this AddAdherenceExplanationAdminRequest.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this AddAdherenceExplanationAdminRequest.
        The length of the adherence explanation in minutes

        :return: The length_minutes of this AddAdherenceExplanationAdminRequest.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this AddAdherenceExplanationAdminRequest.
        The length of the adherence explanation in minutes

        :param length_minutes: The length_minutes of this AddAdherenceExplanationAdminRequest.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def notes(self) -> str:
        """
        Gets the notes of this AddAdherenceExplanationAdminRequest.
        Notes about the adherence explanation

        :return: The notes of this AddAdherenceExplanationAdminRequest.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes: str) -> None:
        """
        Sets the notes of this AddAdherenceExplanationAdminRequest.
        Notes about the adherence explanation

        :param notes: The notes of this AddAdherenceExplanationAdminRequest.
        :type: str
        """
        

        self._notes = notes

    @property
    def status(self) -> str:
        """
        Gets the status of this AddAdherenceExplanationAdminRequest.
        The status of the adherence explanation

        :return: The status of this AddAdherenceExplanationAdminRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this AddAdherenceExplanationAdminRequest.
        The status of the adherence explanation

        :param status: The status of this AddAdherenceExplanationAdminRequest.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "Approved", "Denied"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

